/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class RetentionLease
implements ToXContentObject,
Writeable {
    private final String id;
    private final long retainingSequenceNumber;
    private final long timestamp;
    private final String source;
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField RETAINING_SEQUENCE_NUMBER_FIELD = new ParseField("retaining_sequence_number", new String[0]);
    private static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp", new String[0]);
    private static final ParseField SOURCE_FIELD = new ParseField("source", new String[0]);
    private static final ConstructingObjectParser<RetentionLease, Void> PARSER = new ConstructingObjectParser("retention_leases", a -> new RetentionLease((String)a[0], (Long)a[1], (Long)a[2], (String)a[3]));

    public String id() {
        return this.id;
    }

    public long retainingSequenceNumber() {
        return this.retainingSequenceNumber;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String source() {
        return this.source;
    }

    public RetentionLease(String id, long retainingSequenceNumber, long timestamp, String source) {
        Objects.requireNonNull(id);
        if (id.isEmpty()) {
            throw new IllegalArgumentException("retention lease ID can not be empty");
        }
        if (retainingSequenceNumber < 0L) {
            throw new IllegalArgumentException("retention lease retaining sequence number [" + retainingSequenceNumber + "] out of range");
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("retention lease timestamp [" + timestamp + "] out of range");
        }
        Objects.requireNonNull(source);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("retention lease source can not be empty");
        }
        this.id = id;
        this.retainingSequenceNumber = retainingSequenceNumber;
        this.timestamp = timestamp;
        this.source = switch (source) {
            case "ccr" -> "ccr";
            case "peer recovery" -> "peer recovery";
            default -> source;
        };
    }

    public RetentionLease(StreamInput in) throws IOException {
        this(in.readString(), in.readZLong(), in.readVLong(), in.readString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeZLong(this.retainingSequenceNumber);
        out.writeVLong(this.timestamp);
        out.writeString(this.source);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(RETAINING_SEQUENCE_NUMBER_FIELD.getPreferredName(), this.retainingSequenceNumber);
        builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestamp);
        builder.field(SOURCE_FIELD.getPreferredName(), this.source);
        builder.endObject();
        return builder;
    }

    public static RetentionLease fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetentionLease that = (RetentionLease)o;
        return Objects.equals(this.id, that.id) && this.retainingSequenceNumber == that.retainingSequenceNumber && this.timestamp == that.timestamp && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.retainingSequenceNumber, this.timestamp, this.source);
    }

    public String toString() {
        return "RetentionLease{id='" + this.id + "', retainingSequenceNumber=" + this.retainingSequenceNumber + ", timestamp=" + this.timestamp + ", source='" + this.source + "'}";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETAINING_SEQUENCE_NUMBER_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIMESTAMP_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SOURCE_FIELD);
    }
}

