/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.DotExpandingXContentParser;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.FieldArrayContext;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.PassThroughObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFields;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.index.mapper.vectors.VectorsFormatProvider;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.FlatteningXContentParser;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class DocumentParserContext {
    private final MappingLookup mappingLookup;
    private final MappingParserContext mappingParserContext;
    private final SourceToParse sourceToParse;
    private final Set<String> ignoredFields;
    private final List<IgnoredSourceFieldMapper.NameValue> ignoredFieldValues;
    private Scope currentScope;
    private final Map<String, List<Mapper>> dynamicMappers;
    private final DynamicMapperSize dynamicMappersSize;
    private final Map<String, ObjectMapper> dynamicObjectMappers;
    private final Map<String, List<RuntimeField>> dynamicRuntimeFields;
    private final RoutingFields routingFields;
    private final ObjectMapper parent;
    private final ObjectMapper.Dynamic dynamic;
    private String id;
    private Field version;
    private final SeqNoFieldMapper.SequenceIDFields seqID;
    private final Set<String> fieldsAppliedFromTemplates;
    private FieldArrayContext fieldArrayContext;
    private final Set<String> copyToFields;
    private boolean recordedSource;
    private XContentParser.Token lastSetToken;

    private DocumentParserContext(MappingLookup mappingLookup, MappingParserContext mappingParserContext, SourceToParse sourceToParse, Set<String> ignoreFields, List<IgnoredSourceFieldMapper.NameValue> ignoredFieldValues, Scope currentScope, Map<String, List<Mapper>> dynamicMappers, Map<String, ObjectMapper> dynamicObjectMappers, Map<String, List<RuntimeField>> dynamicRuntimeFields, String id, Field version, SeqNoFieldMapper.SequenceIDFields seqID, RoutingFields routingFields, ObjectMapper parent, ObjectMapper.Dynamic dynamic, Set<String> fieldsAppliedFromTemplates, Set<String> copyToFields, DynamicMapperSize dynamicMapperSize, boolean recordedSource) {
        this.mappingLookup = mappingLookup;
        this.mappingParserContext = mappingParserContext;
        this.sourceToParse = sourceToParse;
        this.ignoredFields = ignoreFields;
        this.ignoredFieldValues = ignoredFieldValues;
        this.currentScope = currentScope;
        this.dynamicMappers = dynamicMappers;
        this.dynamicObjectMappers = dynamicObjectMappers;
        this.dynamicRuntimeFields = dynamicRuntimeFields;
        this.id = id;
        this.version = version;
        this.seqID = seqID;
        this.routingFields = routingFields;
        this.parent = parent;
        this.dynamic = dynamic;
        this.fieldsAppliedFromTemplates = fieldsAppliedFromTemplates;
        this.copyToFields = copyToFields;
        this.dynamicMappersSize = dynamicMapperSize;
        this.recordedSource = recordedSource;
    }

    private DocumentParserContext(ObjectMapper parent, ObjectMapper.Dynamic dynamic, DocumentParserContext in) {
        this(in.mappingLookup, in.mappingParserContext, in.sourceToParse, in.ignoredFields, in.ignoredFieldValues, in.currentScope, in.dynamicMappers, in.dynamicObjectMappers, in.dynamicRuntimeFields, in.id, in.version, in.seqID, in.routingFields, parent, dynamic, in.fieldsAppliedFromTemplates, in.copyToFields, in.dynamicMappersSize, in.recordedSource);
    }

    protected DocumentParserContext(MappingLookup mappingLookup, MappingParserContext mappingParserContext, SourceToParse source, ObjectMapper parent, ObjectMapper.Dynamic dynamic) {
        this(mappingLookup, mappingParserContext, source, new HashSet<String>(), new ArrayList<IgnoredSourceFieldMapper.NameValue>(), Scope.SINGLETON, new HashMap<String, List<Mapper>>(), new HashMap<String, ObjectMapper>(), new HashMap<String, List<RuntimeField>>(), null, null, SeqNoFieldMapper.SequenceIDFields.emptySeqID(mappingParserContext.getIndexSettings().seqNoIndexOptions()), RoutingFields.fromIndexSettings(mappingParserContext.getIndexSettings()), parent, dynamic, new HashSet<String>(), new HashSet<String>(mappingLookup.fieldTypesLookup().getCopyToDestinationFields()), new DynamicMapperSize(), false);
    }

    public final IndexSettings indexSettings() {
        return this.mappingParserContext.getIndexSettings();
    }

    public final IndexAnalyzers indexAnalyzers() {
        return this.mappingParserContext.getIndexAnalyzers();
    }

    public final RootObjectMapper root() {
        return this.mappingLookup.getMapping().getRoot();
    }

    public final ObjectMapper parent() {
        return this.parent;
    }

    public final MappingLookup mappingLookup() {
        return this.mappingLookup;
    }

    public final MetadataFieldMapper getMetadataMapper(String mapperName) {
        return this.mappingLookup.getMapping().getMetadataMapperByName(mapperName);
    }

    public final List<VectorsFormatProvider> getVectorFormatProviders() {
        return this.mappingParserContext.getVectorsFormatProviders();
    }

    public final MappingParserContext dynamicTemplateParserContext(DateFormatter dateFormatter) {
        return this.mappingParserContext.createDynamicTemplateContext(dateFormatter);
    }

    public final SourceToParse sourceToParse() {
        return this.sourceToParse;
    }

    public final String routing() {
        return this.mappingParserContext.getIndexSettings().getMode() == IndexMode.TIME_SERIES ? null : this.sourceToParse.routing();
    }

    public final void addIgnoredField(String field) {
        this.ignoredFields.add(field);
    }

    public final Collection<String> getIgnoredFields() {
        return Collections.unmodifiableCollection(this.ignoredFields);
    }

    public final void addIgnoredField(IgnoredSourceFieldMapper.NameValue values) {
        if (this.canAddIgnoredField()) {
            this.ignoredFieldValues.add(values);
        }
    }

    public final Collection<IgnoredSourceFieldMapper.NameValue> getIgnoredFieldValues() {
        return Collections.unmodifiableCollection(this.ignoredFieldValues);
    }

    public final DocumentParserContext addIgnoredFieldFromContext(IgnoredSourceFieldMapper.NameValue ignoredFieldWithNoSource) throws IOException {
        if (this.canAddIgnoredField()) {
            assert (ignoredFieldWithNoSource != null);
            assert (ignoredFieldWithNoSource.value() == null);
            Tuple<DocumentParserContext, XContentBuilder> tuple = XContentDataHelper.cloneSubContext(this);
            this.addIgnoredField(ignoredFieldWithNoSource.cloneWithValue(XContentDataHelper.encodeXContentBuilder(tuple.v2())));
            return tuple.v1();
        }
        return this;
    }

    BytesRef encodeFlattenedToken() throws IOException {
        boolean old = this.path().isWithinLeafObject();
        this.path().setWithinLeafObject(true);
        BytesRef encoded = XContentDataHelper.encodeToken(this.parser());
        this.path().setWithinLeafObject(old);
        return encoded;
    }

    public final DocumentParserContext maybeCloneForArray(Mapper mapper) throws IOException {
        if (this.canAddIgnoredField() && mapper instanceof ObjectMapper && !(mapper instanceof NestedObjectMapper) && this.currentScope != Scope.ARRAY) {
            DocumentParserContext subcontext = this.switchParser(this.parser());
            subcontext.currentScope = Scope.ARRAY;
            return subcontext;
        }
        return this;
    }

    public final void addToFieldNames(String field) {
        FieldNamesFieldMapper fieldNamesFieldMapper = (FieldNamesFieldMapper)this.getMetadataMapper("_field_names");
        if (fieldNamesFieldMapper != null) {
            fieldNamesFieldMapper.addFieldNames(this, field);
        }
    }

    public final Field version() {
        return this.version;
    }

    public final void version(Field version) {
        this.version = version;
    }

    public final String id() {
        if (this.id == null) {
            assert (false) : "id field mapper has not set the id";
            throw new IllegalStateException("id field mapper has not set the id");
        }
        return this.id;
    }

    public final void id(String id) {
        this.id = id;
    }

    public final SeqNoFieldMapper.SequenceIDFields seqID() {
        return this.seqID;
    }

    final void setRecordedSource() {
        this.recordedSource = true;
    }

    final boolean getRecordedSource() {
        return this.recordedSource;
    }

    public final boolean canAddIgnoredField() {
        return this.mappingLookup.isSourceSynthetic() && !this.recordedSource && !this.indexSettings().getSkipIgnoredSourceWrite();
    }

    Mapper.SourceKeepMode sourceKeepModeFromIndexSettings() {
        return this.indexSettings().sourceKeepMode();
    }

    public final String documentDescription() {
        IdFieldMapper idMapper = (IdFieldMapper)this.getMetadataMapper("_id");
        return idMapper.documentDescription(this);
    }

    public Mapper getMapper(String name) {
        return this.parent.getMapper(name);
    }

    public ObjectMapper.Dynamic dynamic() {
        return this.dynamic;
    }

    public void markFieldAsAppliedFromTemplate(String fieldName) {
        this.fieldsAppliedFromTemplates.add(fieldName);
    }

    public boolean isFieldAppliedFromTemplate(String name) {
        return this.fieldsAppliedFromTemplates.contains(name);
    }

    public void markFieldAsCopyTo(String fieldName) {
        this.copyToFields.add(fieldName);
    }

    public boolean isCopyToDestinationField(String name) {
        return this.copyToFields.contains(name);
    }

    public void processArrayOffsets(DocumentParserContext context) throws IOException {
        if (this.fieldArrayContext != null) {
            this.fieldArrayContext.addToLuceneDocument(context);
        }
    }

    public FieldArrayContext getOffSetContext() {
        if (this.fieldArrayContext == null) {
            this.fieldArrayContext = new FieldArrayContext();
        }
        return this.fieldArrayContext;
    }

    public void setImmediateXContentParent(XContentParser.Token token) {
        this.lastSetToken = token;
    }

    public XContentParser.Token getImmediateXContentParent() {
        return this.lastSetToken;
    }

    public boolean isImmediateParentAnArray() {
        return this.lastSetToken == XContentParser.Token.START_ARRAY;
    }

    public final boolean addDynamicMapper(Mapper mapper) {
        if (mapper instanceof ObjectMapper) {
            MappingLookup.checkObjectDepthLimit(this.indexSettings().getMappingDepthLimit(), mapper.fullPath());
        }
        if (this.mappingLookup.getMapper(mapper.fullPath()) == null && !this.mappingLookup.objectMappers().containsKey(mapper.fullPath()) && !this.dynamicMappers.containsKey(mapper.fullPath())) {
            int mapperSize = mapper.getTotalFieldsCount();
            int additionalFieldsToAdd = this.getNewFieldsSize() + mapperSize;
            if (this.indexSettings().isIgnoreDynamicFieldsBeyondLimit()) {
                if (this.mappingLookup.exceedsLimit(this.indexSettings().getMappingTotalFieldsLimit(), additionalFieldsToAdd)) {
                    if (this.canAddIgnoredField()) {
                        try {
                            this.addIgnoredField(IgnoredSourceFieldMapper.NameValue.fromContext(this, mapper.fullPath(), this.encodeFlattenedToken()));
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("failed to parse field [" + mapper.fullPath() + " ]", e);
                        }
                    }
                    this.addIgnoredField(mapper.fullPath());
                    return false;
                }
            } else {
                this.mappingLookup.checkFieldLimit(this.indexSettings().getMappingTotalFieldsLimit(), additionalFieldsToAdd);
            }
            this.dynamicMappersSize.add(mapperSize);
        }
        if (mapper instanceof ObjectMapper) {
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            this.dynamicObjectMappers.put(objectMapper.fullPath(), objectMapper);
            for (Mapper submapper : objectMapper.mappers.values()) {
                this.addDynamicMapper(submapper);
            }
        }
        this.dynamicMappers.computeIfAbsent(mapper.fullPath(), k -> new ArrayList()).add(mapper);
        return true;
    }

    int getNewFieldsSize() {
        return this.dynamicMappersSize.get() + this.dynamicRuntimeFields.size();
    }

    public final boolean hasDynamicMappersOrRuntimeFields() {
        return this.hasDynamicMappers() || !this.dynamicRuntimeFields.isEmpty();
    }

    public final boolean hasDynamicMappers() {
        return !this.dynamicMappers.isEmpty();
    }

    public final List<Mapper> getDynamicMappers() {
        return this.dynamicMappers.values().stream().flatMap(Collection::stream).toList();
    }

    public final List<Mapper> getDynamicMappers(String fieldName) {
        return this.dynamicMappers.get(fieldName);
    }

    public void updateDynamicMappers(String name, List<Mapper> mappers) {
        this.dynamicMappers.remove(name);
        mappers.forEach(this::addDynamicMapper);
    }

    final ObjectMapper getDynamicObjectMapper(String name) {
        return this.dynamicObjectMappers.get(name);
    }

    final boolean addDynamicRuntimeField(RuntimeField runtimeField) {
        if (!this.dynamicRuntimeFields.containsKey(runtimeField.name())) {
            if (this.indexSettings().isIgnoreDynamicFieldsBeyondLimit()) {
                if (this.mappingLookup.exceedsLimit(this.indexSettings().getMappingTotalFieldsLimit(), this.getNewFieldsSize() + 1)) {
                    this.addIgnoredField(runtimeField.name());
                    return false;
                }
            } else {
                this.mappingLookup.checkFieldLimit(this.indexSettings().getMappingTotalFieldsLimit(), this.getNewFieldsSize() + 1);
            }
        }
        this.dynamicRuntimeFields.computeIfAbsent(runtimeField.name(), k -> new ArrayList(1)).add(runtimeField);
        return true;
    }

    public final List<RuntimeField> getDynamicRuntimeFields() {
        return this.dynamicRuntimeFields.values().stream().flatMap(Collection::stream).toList();
    }

    public abstract Iterable<LuceneDocument> nonRootDocuments();

    public final RootObjectMapper.Builder updateRoot() {
        return this.mappingLookup.getMapping().getRoot().newBuilder(this.mappingParserContext.getIndexSettings().getIndexVersionCreated());
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    boolean inArrayScope() {
        return this.currentScope == Scope.ARRAY;
    }

    public final DocumentParserContext createChildContext(ObjectMapper parent) {
        return new Wrapper(parent, this);
    }

    public final DocumentParserContext createNestedContext(NestedObjectMapper nestedMapper) {
        if (this.isWithinCopyTo()) {
            return this;
        }
        LuceneDocument doc = new LuceneDocument(nestedMapper.fullPath(), this.doc());
        IndexableField idField = doc.getParent().getField("_id");
        if (idField != null) {
            doc.add(new StringField("_id", idField.binaryValue(), Field.Store.NO));
        } else if (this.indexSettings().getMode() == IndexMode.TIME_SERIES) {
            assert (!this.getRoutingFields().equals(RoutingFields.Noop.INSTANCE));
        } else {
            throw new IllegalStateException("The root document of a nested document should have an _id field");
        }
        doc.add(NestedPathFieldMapper.field(this.indexSettings().getIndexVersionCreated(), nestedMapper.nestedTypePath()));
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final DocumentParserContext switchDoc(final LuceneDocument document) {
        Wrapper cloned = new Wrapper(this, this.parent, this){

            @Override
            public LuceneDocument doc() {
                return document;
            }
        };
        cloned.currentScope = Scope.NESTED;
        return cloned;
    }

    public final DocumentParserContext createCopyToContext(String copyToField, final LuceneDocument doc) throws IOException {
        ObjectMapper parent;
        if (this.mappingLookup.isSourceSynthetic() && !this.indexSettings().getSkipIgnoredSourceWrite() && (parent = this.root().findParentMapper(copyToField)) != null) {
            int offset = parent.isRoot() ? 0 : parent.fullPath().length() + 1;
            this.ignoredFieldValues.add(new IgnoredSourceFieldMapper.NameValue(copyToField, offset, XContentDataHelper.voidValue(), doc));
        }
        final ContentPath path = new ContentPath();
        final XContentParser parser = DotExpandingXContentParser.expandDots(new CopyToParser(copyToField, this.parser()), path);
        return new Wrapper(this, this.root(), this){

            @Override
            public ContentPath path() {
                return path;
            }

            @Override
            public XContentParser parser() {
                return parser;
            }

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }

            @Override
            public LuceneDocument doc() {
                return doc;
            }
        };
    }

    public final DocumentParserContext createFlattenContext(String fieldName) {
        final FlatteningXContentParser flatteningParser = new FlatteningXContentParser(this.parser(), fieldName);
        return new Wrapper(this, this.parent(), this){

            @Override
            public XContentParser parser() {
                return flatteningParser;
            }
        };
    }

    public final DocumentParserContext switchParser(final XContentParser parser) {
        return new Wrapper(this, this.parent, this){

            @Override
            public XContentParser parser() {
                return parser;
            }
        };
    }

    public RoutingFields getRoutingFields() {
        return this.routingFields;
    }

    public abstract ContentPath path();

    public final MapperBuilderContext createDynamicMapperBuilderContext() {
        String p = this.path().pathAsText("");
        if (p.endsWith(".")) {
            p = p.substring(0, p.length() - 1);
        }
        boolean containsDimensions = false;
        ObjectMapper objectMapper = this.mappingLookup.objectMappers().get(p);
        if (objectMapper instanceof PassThroughObjectMapper) {
            PassThroughObjectMapper passThroughObjectMapper = (PassThroughObjectMapper)objectMapper;
            containsDimensions = passThroughObjectMapper.containsDimensions();
        }
        return new MapperBuilderContext(p, this.mappingLookup.isSourceSynthetic(), this.mappingLookup.isDataStreamTimestampFieldEnabled(), containsDimensions, this.dynamic, MapperService.MergeReason.MAPPING_UPDATE, false);
    }

    public abstract XContentParser parser();

    public abstract LuceneDocument rootDoc();

    public abstract LuceneDocument doc();

    protected abstract void addDoc(LuceneDocument var1);

    @Nullable
    public abstract BytesRef getTsid();

    public final DynamicTemplate findDynamicTemplate(String fieldName, DynamicTemplate.XContentFieldType matchType) {
        String pathAsString = this.path().pathAsText(fieldName);
        String matchTemplateName = this.sourceToParse().dynamicTemplates().get(pathAsString);
        for (DynamicTemplate template : this.root().dynamicTemplates()) {
            if (!template.match(matchTemplateName, pathAsString, fieldName, matchType)) continue;
            return template;
        }
        if (matchTemplateName != null) {
            throw new DocumentParsingException(this.parser().getTokenLocation(), "Can't find dynamic template for dynamic template name [" + matchTemplateName + "] of field [" + pathAsString + "]");
        }
        return null;
    }

    private static enum Scope {
        SINGLETON,
        ARRAY,
        NESTED;

    }

    private static final class DynamicMapperSize {
        private int dynamicMapperSize = 0;

        private DynamicMapperSize() {
        }

        public void add(int mapperSize) {
            this.dynamicMapperSize += mapperSize;
        }

        public int get() {
            return this.dynamicMapperSize;
        }
    }

    private static class Wrapper
    extends DocumentParserContext {
        private final DocumentParserContext in;

        private Wrapper(ObjectMapper parent, DocumentParserContext in) {
            super(parent, parent.dynamic == null ? in.dynamic : parent.dynamic, in);
            this.in = in;
        }

        private Wrapper(RootObjectMapper root, DocumentParserContext in) {
            super(root, ObjectMapper.Dynamic.getRootDynamic(in.mappingLookup()), in);
            this.in = in;
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            return this.in.nonRootDocuments();
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public LuceneDocument doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            this.in.addDoc(doc);
        }

        @Override
        public void processArrayOffsets(DocumentParserContext context) throws IOException {
            this.in.processArrayOffsets(context);
        }

        @Override
        public FieldArrayContext getOffSetContext() {
            return this.in.getOffSetContext();
        }

        @Override
        public void setImmediateXContentParent(XContentParser.Token token) {
            this.in.setImmediateXContentParent(token);
        }

        @Override
        public XContentParser.Token getImmediateXContentParent() {
            return this.in.getImmediateXContentParent();
        }

        @Override
        public boolean isImmediateParentAnArray() {
            return this.in.isImmediateParentAnArray();
        }

        @Override
        public BytesRef getTsid() {
            return this.in.getTsid();
        }
    }

    private static class CopyToParser
    extends FilterXContentParserWrapper {
        private State state = State.FIELD;
        private final String field;

        CopyToParser(String fieldName, XContentParser in) {
            super(in);
            this.field = fieldName;
            assert (in.currentToken().isValue() || in.currentToken() == XContentParser.Token.VALUE_NULL);
        }

        @Override
        public XContentParser.Token nextToken() throws IOException {
            if (this.state == State.FIELD) {
                this.state = State.VALUE;
                return this.delegate().currentToken();
            }
            return XContentParser.Token.END_OBJECT;
        }

        @Override
        public XContentParser.Token currentToken() {
            if (this.state == State.FIELD) {
                return XContentParser.Token.FIELD_NAME;
            }
            return this.delegate().currentToken();
        }

        @Override
        public String currentName() throws IOException {
            return this.field;
        }

        static enum State {
            FIELD,
            VALUE;

        }
    }
}

