/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public abstract class BlockDocValuesReader
implements BlockLoader.AllReader {
    private final Thread creationThread = Thread.currentThread();

    protected abstract int docId();

    @Override
    public final boolean canReuse(int startingDocID) {
        return this.creationThread == Thread.currentThread() && this.docId() <= startingDocID;
    }

    public abstract String toString();

    private static class Booleans
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;

        Booleans(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BooleanBuilder builder = factory.booleansFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BooleanBuilder)builder);
        }

        private void read(int doc, BlockLoader.BooleanBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Booleans";
        }
    }

    private static class SingletonBooleans
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        SingletonBooleans(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BooleanBuilder builder = factory.booleansFromDocValues(docs.count() - offset);){
                int lastDoc = -1;
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < lastDoc) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendBoolean(this.numericDocValues.longValue() != 0L);
                    } else {
                        builder.appendNull();
                    }
                    lastDoc = doc;
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.BooleanBuilder blockBuilder = (BlockLoader.BooleanBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendBoolean(this.numericDocValues.longValue() != 0L);
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonBooleans";
        }
    }

    public static class BooleansBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public BooleansBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.BooleanBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.booleans(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton(docValues);
                if (singleton != null) {
                    return new SingletonBooleans(singleton);
                }
                return new Booleans(docValues);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonBooleans(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    private static class BitDenseVectorFromBinary
    extends ByteDenseVectorFromBinary {
        BitDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion) {
            super(docValues, dims, indexVersion, dims / 8);
        }

        @Override
        public String toString() {
            return "BitDenseVectorFromBinary.Bytes";
        }
    }

    private static class ByteDenseVectorFromBinary
    extends AbstractDenseVectorFromBinary<byte[]> {
        ByteDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion) {
            this(docValues, dims, indexVersion, dims);
        }

        protected ByteDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion, int readScratchSize) {
            super(docValues, dims, indexVersion, new byte[readScratchSize]);
        }

        @Override
        public String toString() {
            return "ByteDenseVectorFromBinary.Bytes";
        }

        @Override
        protected void writeScratchToBuilder(byte[] scratch, BlockLoader.FloatBuilder builder) {
            for (byte value : scratch) {
                builder.appendFloat(value);
            }
        }

        @Override
        protected void decodeDenseVector(BytesRef bytesRef, byte[] scratch) {
            VectorEncoderDecoder.decodeDenseVector(this.indexVersion, bytesRef, scratch);
        }
    }

    private static class FloatDenseVectorFromBinary
    extends AbstractDenseVectorFromBinary<float[]> {
        FloatDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion) {
            super(docValues, dims, indexVersion, new float[dims]);
        }

        @Override
        protected void writeScratchToBuilder(float[] scratch, BlockLoader.FloatBuilder builder) {
            for (float value : scratch) {
                builder.appendFloat(value);
            }
        }

        @Override
        protected void decodeDenseVector(BytesRef bytesRef, float[] scratch) {
            VectorEncoderDecoder.decodeDenseVector(this.indexVersion, bytesRef, scratch);
        }

        @Override
        public String toString() {
            return "FloatDenseVectorFromBinary.Bytes";
        }
    }

    private static abstract class AbstractDenseVectorFromBinary<T>
    extends BlockDocValuesReader {
        protected final BinaryDocValues docValues;
        protected final IndexVersion indexVersion;
        protected final int dimensions;
        protected final T scratch;

        AbstractDenseVectorFromBinary(BinaryDocValues docValues, int dims, IndexVersion indexVersion, T scratch) {
            this.docValues = docValues;
            this.indexVersion = indexVersion;
            this.dimensions = dims;
            this.scratch = scratch;
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.FloatBuilder)builder);
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.FloatBuilder builder = factory.denseVectors(docs.count() - offset, this.dimensions);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        private void read(int doc, BlockLoader.FloatBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytesRef = this.docValues.binaryValue();
            assert (bytesRef.length > 0);
            this.decodeDenseVector(bytesRef, this.scratch);
            builder.beginPositionEntry();
            this.writeScratchToBuilder(this.scratch, builder);
            builder.endPositionEntry();
        }

        protected abstract void decodeDenseVector(BytesRef var1, T var2);

        protected abstract void writeScratchToBuilder(T var1, BlockLoader.FloatBuilder var2);
    }

    public static class DenseVectorFromBinaryBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;
        private final int dims;
        private final IndexVersion indexVersion;
        private final DenseVectorFieldMapper.ElementType elementType;

        public DenseVectorFromBinaryBlockLoader(String fieldName, int dims, IndexVersion indexVersion, DenseVectorFieldMapper.ElementType elementType) {
            this.fieldName = fieldName;
            this.dims = dims;
            this.indexVersion = indexVersion;
            this.elementType = elementType;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.denseVectors(expectedCount, this.dims);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
            if (docValues == null) {
                return new BlockLoader.ConstantNullsReader();
            }
            return switch (this.elementType) {
                default -> throw new MatchException(null, null);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatDenseVectorFromBinary(docValues, this.dims, this.indexVersion);
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteDenseVectorFromBinary(docValues, this.dims, this.indexVersion);
                case DenseVectorFieldMapper.ElementType.BIT -> new BitDenseVectorFromBinary(docValues, this.dims, this.indexVersion);
            };
        }
    }

    public static class BytesRefsFromBinary
    extends AbstractBytesRefsFromBinary {
        public BytesRefsFromBinary(BinaryDocValues docValues) {
            super(docValues);
        }

        @Override
        void read(int doc, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytes = this.docValues.binaryValue();
            builder.appendBytesRef(bytes);
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Bytes";
        }
    }

    static class BytesRefsFromCustomBinary
    extends AbstractBytesRefsFromBinary {
        private final ByteArrayStreamInput in = new ByteArrayStreamInput();
        private final BytesRef scratch = new BytesRef();

        BytesRefsFromCustomBinary(BinaryDocValues docValues) {
            super(docValues);
        }

        @Override
        void read(int doc, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytes = this.docValues.binaryValue();
            assert (bytes.length > 0);
            this.in.reset(bytes.bytes, bytes.offset, bytes.length);
            int count = this.in.readVInt();
            this.scratch.bytes = bytes.bytes;
            if (count == 1) {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                builder.appendBytesRef(this.scratch);
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                this.in.setPosition(this.scratch.offset + this.scratch.length);
                builder.appendBytesRef(this.scratch);
            }
            builder.endPositionEntry();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.BytesCustom";
        }
    }

    static abstract class AbstractBytesRefsFromBinary
    extends BlockDocValuesReader {
        protected final BinaryDocValues docValues;

        AbstractBytesRefsFromBinary(BinaryDocValues docValues) {
            this.docValues = docValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        abstract void read(int var1, BlockLoader.BytesRefBuilder var2) throws IOException;
    }

    public static class BytesRefsFromCustomBinaryBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public BytesRefsFromCustomBinaryBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            BinaryDocValues docValues = context.reader().getBinaryDocValues(this.fieldName);
            if (docValues == null) {
                return new BlockLoader.ConstantNullsReader();
            }
            return new BytesRefsFromCustomBinary(docValues);
        }
    }

    private static class Ordinals
    extends BlockDocValuesReader {
        private final SortedSetDocValues ordinals;

        Ordinals(SortedSetDocValues ordinals) {
            this.ordinals = ordinals;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            if (docs.count() - offset == 1) {
                return this.readSingleDoc(factory, docs.get(offset));
            }
            try (BlockLoader.SortedSetOrdinalsBuilder builder = factory.sortedSetOrdinalsBuilder(this.ordinals, docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.ordinals.docID()) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (!this.ordinals.advanceExact(doc)) {
                        builder.appendNull();
                        continue;
                    }
                    int count = this.ordinals.docValueCount();
                    if (count == 1) {
                        builder.appendOrd(Math.toIntExact(this.ordinals.nextOrd()));
                        continue;
                    }
                    builder.beginPositionEntry();
                    for (int c = 0; c < count; ++c) {
                        builder.appendOrd(Math.toIntExact(this.ordinals.nextOrd()));
                    }
                    builder.endPositionEntry();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        private BlockLoader.Block readSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                return factory.constantNulls(1);
            }
            int count = this.ordinals.docValueCount();
            if (count == 1) {
                BytesRef v = this.ordinals.lookupOrd(this.ordinals.nextOrd());
                return factory.constantBytes(BytesRef.deepCopyOf(v), 1);
            }
            try (BlockLoader.BytesRefBuilder builder = factory.bytesRefsFromDocValues(count);){
                builder.beginPositionEntry();
                for (int c = 0; c < count; ++c) {
                    BytesRef v = this.ordinals.lookupOrd(this.ordinals.nextOrd());
                    builder.appendBytesRef(v);
                }
                builder.endPositionEntry();
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        private void read(int docId, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                builder.appendNull();
                return;
            }
            int count = this.ordinals.docValueCount();
            if (count == 1) {
                builder.appendBytesRef(this.ordinals.lookupOrd(this.ordinals.nextOrd()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBytesRef(this.ordinals.lookupOrd(this.ordinals.nextOrd()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Ordinals";
        }
    }

    private static class SingletonOrdinals
    extends BlockDocValuesReader {
        private final SortedDocValues ordinals;

        SingletonOrdinals(SortedDocValues ordinals) {
            this.ordinals = ordinals;
        }

        private BlockLoader.Block readSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                BytesRef v = this.ordinals.lookupOrd(this.ordinals.ordValue());
                return factory.constantBytes(BytesRef.deepCopyOf(v), 1);
            }
            return factory.constantNulls(1);
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block block;
            if (docs.count() - offset == 1) {
                return this.readSingleDoc(factory, docs.get(offset));
            }
            SortedDocValues sortedDocValues = this.ordinals;
            if (sortedDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (block = (direct = (BlockLoader.OptionalColumnAtATimeReader)((Object)sortedDocValues)).tryRead(factory, docs, offset, nullsFiltered, null, false)) != null) {
                return block;
            }
            try (BlockLoader.SingletonOrdinalsBuilder builder = factory.singletonOrdinalsBuilder(this.ordinals, docs.count() - offset, false);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (this.ordinals.advanceExact(doc)) {
                        builder.appendOrd(this.ordinals.ordValue());
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block2 = builder.build();
                return block2;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(this.ordinals.lookupOrd(this.ordinals.ordValue()));
            } else {
                builder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonOrdinals";
        }
    }

    public static class BytesRefsFromOrdsBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public BytesRefsFromOrdsBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.BytesRefBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedSetDocValues docValues = context.reader().getSortedSetDocValues(this.fieldName);
            if (docValues != null) {
                SortedDocValues singleton = DocValues.unwrapSingleton(docValues);
                if (singleton != null) {
                    return new SingletonOrdinals(singleton);
                }
                return new Ordinals(docValues);
            }
            SortedDocValues singleton = context.reader().getSortedDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonOrdinals(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }

        @Override
        public boolean supportsOrdinals() {
            return true;
        }

        @Override
        public SortedSetDocValues ordinals(LeafReaderContext context) throws IOException {
            return DocValues.getSortedSet(context.reader(), this.fieldName);
        }

        public String toString() {
            return "BytesRefsFromOrds[" + this.fieldName + "]";
        }
    }

    private static class BitDenseVectorValuesBlockReader
    extends ByteDenseVectorValuesBlockReader {
        BitDenseVectorValuesBlockReader(ByteVectorValues floatVectorValues, int dimensions) {
            super(floatVectorValues, dimensions);
        }

        @Override
        protected void assertDimensions() {
            assert (((ByteVectorValues)this.vectorValues).dimension() * 8 == this.dimensions) : "unexpected dimensions for vector value; expected " + this.dimensions + " but got " + ((ByteVectorValues)this.vectorValues).dimension() * 8;
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.BitDenseVectorValuesBlockReader";
        }
    }

    private static class ByteDenseVectorValuesBlockReader
    extends DenseVectorValuesBlockReader<ByteVectorValues> {
        ByteDenseVectorValuesBlockReader(ByteVectorValues floatVectorValues, int dimensions) {
            super(floatVectorValues, dimensions);
        }

        @Override
        protected void appendDoc(BlockLoader.FloatBuilder builder) throws IOException {
            byte[] bytes;
            for (byte aFloat : bytes = ((ByteVectorValues)this.vectorValues).vectorValue(this.iterator.index())) {
                builder.appendFloat(aFloat);
            }
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.ByteDenseVectorValuesBlockReader";
        }
    }

    private static class FloatDenseVectorNormalizedValuesBlockReader
    extends DenseVectorValuesBlockReader<FloatVectorValues> {
        private final NumericDocValues magnitudeDocValues;

        FloatDenseVectorNormalizedValuesBlockReader(FloatVectorValues floatVectorValues, int dimensions, NumericDocValues magnitudeDocValues) {
            super(floatVectorValues, dimensions);
            this.magnitudeDocValues = magnitudeDocValues;
        }

        @Override
        protected void appendDoc(BlockLoader.FloatBuilder builder) throws IOException {
            float[] floats;
            float magnitude = 1.0f;
            if (this.magnitudeDocValues != null && this.magnitudeDocValues.advanceExact(this.iterator.docID())) {
                magnitude = Float.intBitsToFloat((int)this.magnitudeDocValues.longValue());
            }
            for (float aFloat : floats = ((FloatVectorValues)this.vectorValues).vectorValue(this.iterator.index())) {
                builder.appendFloat(aFloat * magnitude);
            }
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.FloatDenseVectorNormalizedValuesBlockReader";
        }
    }

    private static class FloatDenseVectorValuesBlockReader
    extends DenseVectorValuesBlockReader<FloatVectorValues> {
        FloatDenseVectorValuesBlockReader(FloatVectorValues floatVectorValues, int dimensions) {
            super(floatVectorValues, dimensions);
        }

        @Override
        protected void appendDoc(BlockLoader.FloatBuilder builder) throws IOException {
            float[] floats;
            for (float aFloat : floats = ((FloatVectorValues)this.vectorValues).vectorValue(this.iterator.index())) {
                builder.appendFloat(aFloat);
            }
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.FloatDenseVectorValuesBlockReader";
        }
    }

    private static abstract class DenseVectorValuesBlockReader<T extends KnnVectorValues>
    extends BlockDocValuesReader {
        protected final T vectorValues;
        protected final KnnVectorValues.DocIndexIterator iterator;
        protected final int dimensions;

        DenseVectorValuesBlockReader(T vectorValues, int dimensions) {
            this.vectorValues = vectorValues;
            this.iterator = ((KnnVectorValues)vectorValues).iterator();
            this.dimensions = dimensions;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.FloatBuilder builder = factory.denseVectors(docs.count() - offset, this.dimensions);){
                for (int i = offset; i < docs.count(); ++i) {
                    this.read(docs.get(i), builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.FloatBuilder)builder);
        }

        private void read(int doc, BlockLoader.FloatBuilder builder) throws IOException {
            this.assertDimensions();
            if (this.iterator.docID() > doc) {
                builder.appendNull();
            } else if (this.iterator.docID() == doc || this.iterator.advance(doc) == doc) {
                builder.beginPositionEntry();
                this.appendDoc(builder);
                builder.endPositionEntry();
            } else {
                builder.appendNull();
            }
        }

        protected abstract void appendDoc(BlockLoader.FloatBuilder var1) throws IOException;

        @Override
        public int docId() {
            return this.iterator.docID();
        }

        protected void assertDimensions() {
            assert (((KnnVectorValues)this.vectorValues).dimension() == this.dimensions) : "unexpected dimensions for vector value; expected " + this.dimensions + " but got " + ((KnnVectorValues)this.vectorValues).dimension();
        }
    }

    public static class DenseVectorBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;
        private final int dimensions;
        private final DenseVectorFieldMapper.DenseVectorFieldType fieldType;

        public DenseVectorBlockLoader(String fieldName, int dimensions, DenseVectorFieldMapper.DenseVectorFieldType fieldType) {
            this.fieldName = fieldName;
            this.dimensions = dimensions;
            this.fieldType = fieldType;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.denseVectors(expectedCount, this.dimensions);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            switch (this.fieldType.getElementType()) {
                case FLOAT: {
                    FloatVectorValues floatVectorValues = context.reader().getFloatVectorValues(this.fieldName);
                    if (floatVectorValues == null) break;
                    if (this.fieldType.isNormalized()) {
                        NumericDocValues magnitudeDocValues = context.reader().getNumericDocValues(this.fieldType.name() + "._magnitude");
                        return new FloatDenseVectorNormalizedValuesBlockReader(floatVectorValues, this.dimensions, magnitudeDocValues);
                    }
                    return new FloatDenseVectorValuesBlockReader(floatVectorValues, this.dimensions);
                }
                case BYTE: {
                    ByteVectorValues byteVectorValues = context.reader().getByteVectorValues(this.fieldName);
                    if (byteVectorValues == null) break;
                    return new ByteDenseVectorValuesBlockReader(byteVectorValues, this.dimensions);
                }
                case BIT: {
                    ByteVectorValues byteVectorValues = context.reader().getByteVectorValues(this.fieldName);
                    if (byteVectorValues == null) break;
                    return new BitDenseVectorValuesBlockReader(byteVectorValues, this.dimensions);
                }
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    static class Doubles
    extends BlockDocValuesReader {
        private final SortedNumericDocValues docValues;
        private final ToDouble toDouble;

        Doubles(SortedNumericDocValues docValues, ToDouble toDouble) {
            this.docValues = docValues;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.DoubleBuilder builder = factory.doublesFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.DoubleBuilder)builder);
        }

        private void read(int doc, BlockLoader.DoubleBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.docValues.docValueCount();
            if (count == 1) {
                builder.appendDouble(this.toDouble.convert(this.docValues.nextValue()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendDouble(this.toDouble.convert(this.docValues.nextValue()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Doubles";
        }
    }

    static class SingletonDoubles
    extends BlockDocValuesReader
    implements NumericDocValuesAccessor {
        private final NumericDocValues docValues;
        private final ToDouble toDouble;

        SingletonDoubles(NumericDocValues docValues, ToDouble toDouble) {
            this.docValues = docValues;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block result;
            NumericDocValues numericDocValues = this.docValues;
            if (numericDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (result = (direct = (BlockLoader.OptionalColumnAtATimeReader)((Object)numericDocValues)).tryRead(factory, docs, offset, nullsFiltered, this.toDouble, false)) != null) {
                return result;
            }
            try (BlockLoader.DoubleBuilder builder = factory.doublesFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (this.docValues.advanceExact(doc)) {
                        builder.appendDouble(this.toDouble.convert(this.docValues.longValue()));
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.DoubleBuilder blockBuilder = (BlockLoader.DoubleBuilder)builder;
            if (this.docValues.advanceExact(docId)) {
                blockBuilder.appendDouble(this.toDouble.convert(this.docValues.longValue()));
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.docValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonDoubles";
        }

        @Override
        public NumericDocValues numericDocValues() {
            return this.docValues;
        }
    }

    public static class DoublesBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;
        private final ToDouble toDouble;

        public DoublesBlockLoader(String fieldName, ToDouble toDouble) {
            this.fieldName = fieldName;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.doubles(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton(docValues);
                if (singleton != null) {
                    return new SingletonDoubles(singleton, this.toDouble);
                }
                return new Doubles(docValues, this.toDouble);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonDoubles(singleton, this.toDouble);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    public static interface ToDouble {
        public double convert(long var1);
    }

    static class Ints
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;

        Ints(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.IntBuilder builder = factory.intsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.IntBuilder)builder);
        }

        private void read(int doc, BlockLoader.IntBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Ints";
        }
    }

    static class SingletonInts
    extends BlockDocValuesReader
    implements NumericDocValuesAccessor {
        private final NumericDocValues numericDocValues;

        SingletonInts(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block result;
            NumericDocValues numericDocValues = this.numericDocValues;
            if (numericDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (result = (direct = (BlockLoader.OptionalColumnAtATimeReader)((Object)numericDocValues)).tryRead(factory, docs, offset, nullsFiltered, null, true)) != null) {
                return result;
            }
            try (BlockLoader.IntBuilder builder = factory.intsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.IntBuilder blockBuilder = (BlockLoader.IntBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonInts";
        }

        @Override
        public NumericDocValues numericDocValues() {
            return this.numericDocValues;
        }
    }

    public static class IntsBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public IntsBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.ints(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton(docValues);
                if (singleton != null) {
                    return new SingletonInts(singleton);
                }
                return new Ints(docValues);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonInts(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    static class Longs
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;

        Longs(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.LongBuilder builder = factory.longsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.LongBuilder)builder);
        }

        private void read(int doc, BlockLoader.LongBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendLong(this.numericDocValues.nextValue());
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendLong(this.numericDocValues.nextValue());
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.Longs";
        }
    }

    static class SingletonLongs
    extends BlockDocValuesReader
    implements NumericDocValuesAccessor {
        final NumericDocValues numericDocValues;

        SingletonLongs(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block result;
            NumericDocValues numericDocValues = this.numericDocValues;
            if (numericDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (result = (direct = (BlockLoader.OptionalColumnAtATimeReader)((Object)numericDocValues)).tryRead(factory, docs, offset, nullsFiltered, null, false)) != null) {
                return result;
            }
            try (BlockLoader.LongBuilder builder = factory.longsFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (this.numericDocValues.advanceExact(doc)) {
                        builder.appendLong(this.numericDocValues.longValue());
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            BlockLoader.LongBuilder blockBuilder = (BlockLoader.LongBuilder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendLong(this.numericDocValues.longValue());
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "BlockDocValuesReader.SingletonLongs";
        }

        @Override
        public NumericDocValues numericDocValues() {
            return this.numericDocValues;
        }
    }

    static interface NumericDocValuesAccessor {
        public NumericDocValues numericDocValues();
    }

    public static class LongsBlockLoader
    extends DocValuesBlockLoader {
        private final String fieldName;

        public LongsBlockLoader(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.longs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            SortedNumericDocValues docValues = context.reader().getSortedNumericDocValues(this.fieldName);
            if (docValues != null) {
                NumericDocValues singleton = DocValues.unwrapSingleton(docValues);
                if (singleton != null) {
                    return new SingletonLongs(singleton);
                }
                return new Longs(docValues);
            }
            NumericDocValues singleton = context.reader().getNumericDocValues(this.fieldName);
            if (singleton != null) {
                return new SingletonLongs(singleton);
            }
            return new BlockLoader.ConstantNullsReader();
        }
    }

    public static abstract class DocValuesBlockLoader
    implements BlockLoader {
        public abstract BlockLoader.AllReader reader(LeafReaderContext var1) throws IOException;

        @Override
        public final BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) throws IOException {
            return this.reader(context);
        }

        @Override
        public final BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return this.reader(context);
        }

        @Override
        public final StoredFieldsSpec rowStrideStoredFieldSpec() {
            return StoredFieldsSpec.NO_REQUIREMENTS;
        }

        @Override
        public boolean supportsOrdinals() {
            return false;
        }

        @Override
        public SortedSetDocValues ordinals(LeafReaderContext context) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

