/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.Map;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class FailureStoreMetrics {
    public static final FailureStoreMetrics NOOP = new FailureStoreMetrics(MeterRegistry.NOOP);
    public static final String METRIC_TOTAL = "es.data_stream.ingest.documents.total";
    public static final String METRIC_FAILURE_STORE = "es.data_stream.ingest.documents.failure_store.total";
    public static final String METRIC_REJECTED = "es.data_stream.ingest.documents.rejected.total";
    private final LongCounter totalCounter;
    private final LongCounter failureStoreCounter;
    private final LongCounter rejectedCounter;

    public FailureStoreMetrics(MeterRegistry meterRegistry) {
        this.totalCounter = meterRegistry.registerLongCounter(METRIC_TOTAL, "total number of documents that were sent to a data stream", "unit");
        this.failureStoreCounter = meterRegistry.registerLongCounter(METRIC_FAILURE_STORE, "number of documents that got redirected to the failure store", "unit");
        this.rejectedCounter = meterRegistry.registerLongCounter(METRIC_REJECTED, "number of documents that were rejected", "unit");
    }

    public void incrementTotal(String dataStream) {
        this.totalCounter.incrementBy(1L, Map.of("data_stream", dataStream));
    }

    public void incrementFailureStore(String dataStream, String errorType, ErrorLocation errorLocation) {
        this.failureStoreCounter.incrementBy(1L, Map.of("data_stream", dataStream, "error_type", errorType, "error_location", errorLocation.name()));
    }

    public void incrementRejected(String dataStream, String errorType, ErrorLocation errorLocation, boolean failureStore) {
        this.rejectedCounter.incrementBy(1L, Map.of("data_stream", dataStream, "error_type", errorType, "error_location", errorLocation.name(), "failure_store", failureStore));
    }

    public static enum ErrorLocation {
        PIPELINE,
        SHARD;

    }
}

