/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class TransportSimulateIndexTemplateAction
extends TransportLocalProjectMetadataAction<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private final SystemIndices systemIndices;
    private final Set<IndexSettingProvider> indexSettingProviders;
    private final ClusterSettings clusterSettings;
    private final boolean isDslOnlyMode;

    @Inject
    public TransportSimulateIndexTemplateAction(TransportService transportService, ClusterService clusterService, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, IndicesService indicesService, SystemIndices systemIndices, IndexSettingProviders indexSettingProviders, ProjectResolver projectResolver) {
        super("indices:admin/index_template/simulate_index", actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.systemIndices = systemIndices;
        this.indexSettingProviders = indexSettingProviders.getIndexSettingProviders();
        this.clusterSettings = clusterService.getClusterSettings();
        this.isDslOnlyMode = DataStreamLifecycle.isDataStreamsLifecycleOnlyMode(clusterService.getSettings());
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, SimulateIndexTemplateRequest::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected void localClusterStateOperation(Task task, SimulateIndexTemplateRequest request, ProjectState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ProjectMetadata projectWithTemplate;
        if (request.getIndexTemplateRequest() != null) {
            String simulateTemplateToAdd = "simulate_index_template_" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            projectWithTemplate = TransportSimulateIndexTemplateAction.removeExistingAbstractions(this.indexTemplateService.addIndexTemplateV2(state.metadata(), request.getIndexTemplateRequest().create(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate()), request.getIndexName());
        } else {
            projectWithTemplate = TransportSimulateIndexTemplateAction.removeExistingAbstractions(state.metadata(), request.getIndexName());
        }
        String matchingTemplate = MetadataIndexTemplateService.findV2Template(projectWithTemplate, request.getIndexName(), false);
        if (matchingTemplate == null) {
            listener.onResponse(new SimulateIndexTemplateResponse(null, null));
            return;
        }
        ProjectMetadata tempProjectMetadata = TransportSimulateIndexTemplateAction.resolveTemporaryState(matchingTemplate, request.getIndexName(), projectWithTemplate);
        ComposableIndexTemplate templateV2 = tempProjectMetadata.templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate(matchingTemplate, request.getIndexName(), projectWithTemplate, state.metadata().dataStreams().get(request.getIndexName()), this.isDslOnlyMode, this.xContentRegistry, this.indicesService, this.systemIndices, this.indexSettingProviders);
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempProjectMetadata, matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempProjectMetadata, matchingTemplate, templateV2.indexPatterns()));
        if (request.includeDefaults()) {
            listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping, this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING)));
        } else {
            listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
        }
    }

    private static ProjectMetadata removeExistingAbstractions(ProjectMetadata project, String indexName) {
        return ProjectMetadata.builder(project).removeDataStream(indexName).removeAllIndices().build();
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateIndexTemplateRequest request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }

    public static ProjectMetadata resolveTemporaryState(String matchingTemplate, String indexName, ProjectMetadata simulatedProject) {
        Settings settings = MetadataIndexTemplateService.resolveSettings(simulatedProject, matchingTemplate);
        Settings dummySettings = Settings.builder().put("index.version.created", IndexVersion.current()).put(settings).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata indexMetadata = IndexMetadata.builder(indexName).eventIngestedRange(TransportSimulateIndexTemplateAction.getEventIngestedRange(indexName, simulatedProject)).settings(dummySettings).build();
        return ProjectMetadata.builder(simulatedProject).put(indexMetadata, true).build();
    }

    public static Template resolveTemplate(String matchingTemplate, String indexName, ProjectMetadata simulatedProject, @Nullable DataStream dataStream, boolean isDslOnlyMode, NamedXContentRegistry xContentRegistry, IndicesService indicesService, SystemIndices systemIndices, Set<IndexSettingProvider> indexSettingProviders) throws Exception {
        DataStreamOptions.Builder optionsBuilder;
        DataStreamLifecycle.Template lifecycle;
        List<Map<String, AliasMetadata>> resolvedAliases = MetadataIndexTemplateService.resolveAliases(simulatedProject, matchingTemplate);
        ComposableIndexTemplate template = simulatedProject.templatesV2().get(matchingTemplate);
        Settings templateSettings = TransportSimulateIndexTemplateAction.collectSettings(simulatedProject, dataStream, matchingTemplate, template);
        Settings.Builder dummySettings = Settings.builder().put("index.version.created", IndexVersion.current()).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID());
        List<CompressedXContent> mappings = TransportSimulateIndexTemplateAction.collectMappings(simulatedProject, dataStream, template, indexName, xContentRegistry);
        Instant now = Instant.now();
        Settings.Builder additionalSettings = Settings.builder();
        HashSet<String> overrulingSettings = new HashSet<String>();
        for (IndexSettingProvider indexSettingProvider : indexSettingProviders) {
            Settings.Builder builder = Settings.builder();
            indexSettingProvider.provideAdditionalSettings(indexName, template.getDataStreamTemplate() != null ? indexName : null, simulatedProject.retrieveIndexModeFromTemplate(template), simulatedProject, now, templateSettings, mappings, IndexVersion.current(), builder);
            Settings result = builder.build();
            MetadataCreateIndexService.validateAdditionalSettings(indexSettingProvider, result, additionalSettings);
            dummySettings.put(result);
            additionalSettings.put(result);
            if (!indexSettingProvider.overrulesTemplateAndRequestSettings()) continue;
            overrulingSettings.addAll(result.keySet());
        }
        if (!overrulingSettings.isEmpty()) {
            Settings.Builder filtered = Settings.builder().put(templateSettings);
            for (String setting : overrulingSettings) {
                filtered.remove(setting);
            }
            templateSettings = filtered.build();
        }
        dummySettings.put(templateSettings);
        IndexMetadata indexMetadata = IndexMetadata.builder(indexName).eventIngestedRange(TransportSimulateIndexTemplateAction.getEventIngestedRange(indexName, simulatedProject)).settings(dummySettings).build();
        ProjectMetadata projectMetadata = ProjectMetadata.builder(simulatedProject).put(indexMetadata, true).build();
        List aliases = indicesService.withTempIndexService(indexMetadata, tempIndexService -> MetadataCreateIndexService.resolveAndValidateAliases(indexName, Set.of(), resolvedAliases, tempProjectMetadata, xContentRegistry, tempIndexService.newSearchExecutionContext(0, 0, null, () -> 0L, null, Collections.emptyMap()), IndexService.dateMathExpressionResolverAt(), systemIndices::isSystemName));
        Map<String, AliasMetadata> aliasesByName = aliases == null ? Map.of() : aliases.stream().collect(Collectors.toMap(AliasMetadata::getAlias, Function.identity()));
        CompressedXContent mergedMapping = indicesService.withTempIndexService(indexMetadata, tempIndexService -> {
            MapperService mapperService = tempIndexService.mapperService();
            mapperService.merge("_doc", mappings, MapperService.MergeReason.INDEX_TEMPLATE);
            DocumentMapper documentMapper = mapperService.documentMapper();
            return documentMapper != null ? documentMapper.mappingSource() : null;
        });
        Settings settings = Settings.builder().put(additionalSettings.build()).put(templateSettings).build();
        DataStreamLifecycle.Builder lifecycleBuilder = MetadataIndexTemplateService.resolveLifecycle(simulatedProject, matchingTemplate);
        DataStreamLifecycle.Template template2 = lifecycle = lifecycleBuilder == null ? null : lifecycleBuilder.buildTemplate();
        if (template.getDataStreamTemplate() != null && lifecycle == null && isDslOnlyMode) {
            lifecycle = DataStreamLifecycle.Template.DATA_DEFAULT;
        }
        return new Template(settings, mergedMapping, aliasesByName, lifecycle, (optionsBuilder = MetadataIndexTemplateService.resolveDataStreamOptions(simulatedProject, matchingTemplate)) == null ? null : optionsBuilder.buildTemplate());
    }

    private static List<CompressedXContent> collectMappings(ProjectMetadata simulatedProject, @Nullable DataStream dataStream, ComposableIndexTemplate template, String indexName, NamedXContentRegistry xContentRegistry) throws IOException {
        CompressedXContent dataStreamMappingOverrides;
        String simulatedIndexName = template.getDataStreamTemplate() != null && !indexName.startsWith(".ds-") ? DataStream.getDefaultBackingIndexName(indexName, 1L) : indexName;
        List<CompressedXContent> mappings = MetadataCreateIndexService.collectV2Mappings(null, simulatedProject, template, xContentRegistry, simulatedIndexName);
        if (template.getDataStreamTemplate() != null && dataStream != null && !ComposableIndexTemplate.EMPTY_MAPPINGS.equals(dataStreamMappingOverrides = dataStream.getMappings())) {
            mappings = new ArrayList<CompressedXContent>(mappings);
            mappings.add(dataStreamMappingOverrides);
        }
        return mappings;
    }

    private static Settings collectSettings(ProjectMetadata simulatedProject, @Nullable DataStream dataStream, String templateName, ComposableIndexTemplate template) {
        Settings templateSettings = MetadataIndexTemplateService.resolveSettings(simulatedProject, templateName);
        if (template.getDataStreamTemplate() != null && dataStream != null) {
            templateSettings = templateSettings.merge(dataStream.getSettings());
        }
        return templateSettings;
    }

    private static IndexLongFieldRange getEventIngestedRange(String indexName, ProjectMetadata simulatedProject) {
        IndexMetadata indexMetadata = simulatedProject.index(indexName);
        return indexMetadata == null ? IndexLongFieldRange.NO_SHARDS : indexMetadata.getEventIngestedRange();
    }
}

