/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.CCSTelemetrySnapshot;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsIndices;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodes;
import org.elasticsearch.action.admin.cluster.stats.MappingStats;
import org.elasticsearch.action.admin.cluster.stats.RemoteClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.RepositoryUsageStats;
import org.elasticsearch.action.admin.cluster.stats.VersionStats;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterSnapshotStats;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterStatsResponse
extends BaseNodesResponse<ClusterStatsNodeResponse>
implements ToXContentFragment {
    final ClusterStatsNodes nodesStats;
    final ClusterStatsIndices indicesStats;
    final ClusterHealthStatus status;
    final ClusterSnapshotStats clusterSnapshotStats;
    final RepositoryUsageStats repositoryUsageStats;
    final CCSTelemetrySnapshot ccsMetrics;
    final CCSTelemetrySnapshot esqlMetrics;
    final long timestamp;
    final String clusterUUID;
    private final Map<String, RemoteClusterStats> remoteClustersStats;
    public static final String CCS_TELEMETRY_FIELD_NAME = "_search";
    public static final String ESQL_TELEMETRY_FIELD_NAME = "_esql";

    public ClusterStatsResponse(long timestamp, String clusterUUID, ClusterName clusterName, List<ClusterStatsNodeResponse> nodes, List<FailedNodeException> failures, MappingStats mappingStats, AnalysisStats analysisStats, VersionStats versionStats, ClusterSnapshotStats clusterSnapshotStats, Map<String, RemoteClusterStats> remoteClustersStats) {
        super(clusterName, nodes, failures);
        this.clusterUUID = clusterUUID;
        this.timestamp = timestamp;
        this.nodesStats = new ClusterStatsNodes(nodes);
        this.indicesStats = new ClusterStatsIndices(nodes, mappingStats, analysisStats, versionStats);
        this.ccsMetrics = new CCSTelemetrySnapshot();
        this.esqlMetrics = new CCSTelemetrySnapshot().setUseMRT(false);
        ClusterHealthStatus status = null;
        for (ClusterStatsNodeResponse response : nodes) {
            if (response.clusterStatus() == null) continue;
            status = response.clusterStatus();
            break;
        }
        nodes.forEach(node -> {
            this.ccsMetrics.add(node.getSearchCcsMetrics());
            this.esqlMetrics.add(node.getEsqlCcsMetrics());
        });
        this.status = status;
        this.clusterSnapshotStats = clusterSnapshotStats;
        this.repositoryUsageStats = nodes.stream().map(ClusterStatsNodeResponse::repositoryUsageStats).filter(r -> !r.isEmpty()).findAny().orElse(RepositoryUsageStats.EMPTY);
        this.remoteClustersStats = remoteClustersStats;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public ClusterStatsNodes getNodesStats() {
        return this.nodesStats;
    }

    public ClusterStatsIndices getIndicesStats() {
        return this.indicesStats;
    }

    public CCSTelemetrySnapshot getCcsMetrics() {
        return this.ccsMetrics;
    }

    public Map<String, RemoteClusterStats> getRemoteClustersStats() {
        return this.remoteClustersStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    @Override
    protected List<ClusterStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return (List)TransportAction.localOnly();
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<ClusterStatsNodeResponse> nodes) throws IOException {
        TransportAction.localOnly();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_uuid", this.getClusterUUID());
        builder.field("timestamp", this.getTimestamp());
        if (this.status != null) {
            builder.field("status", this.status.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("indices");
        this.indicesStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("nodes");
        this.nodesStats.toXContent(builder, params);
        builder.endObject();
        builder.field("snapshots");
        this.clusterSnapshotStats.toXContent(builder, params);
        builder.field("repositories");
        this.repositoryUsageStats.toXContent(builder, params);
        builder.startObject("ccs");
        if (this.remoteClustersStats != null) {
            builder.field("clusters", this.remoteClustersStats);
        }
        builder.startObject(CCS_TELEMETRY_FIELD_NAME);
        this.ccsMetrics.toXContent(builder, params);
        builder.endObject();
        if (this.esqlMetrics.getTotalCount() > 0L) {
            builder.startObject(ESQL_TELEMETRY_FIELD_NAME);
            this.esqlMetrics.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public record RemoteClusterStats(String clusterUUID, String mode, Optional<Boolean> skipUnavailable, String transportCompress, Set<String> versions, String status, long nodesCount, long shardsCount, long indicesCount, long indicesBytes, long heapBytes, long memBytes) implements ToXContentFragment
    {
        public RemoteClusterStats(String mode, Optional<Boolean> skipUnavailable, String transportCompress) {
            this("unavailable", mode, skipUnavailable, transportCompress.toLowerCase(Locale.ROOT), Set.of(), "unavailable", 0L, 0L, 0L, 0L, 0L, 0L);
        }

        public RemoteClusterStats acceptResponse(RemoteClusterStatsResponse remoteResponse) {
            return new RemoteClusterStats(remoteResponse.getClusterUUID(), this.mode, this.skipUnavailable, this.transportCompress, remoteResponse.getVersions(), remoteResponse.getStatus().name().toLowerCase(Locale.ROOT), remoteResponse.getNodesCount(), remoteResponse.getShardsCount(), remoteResponse.getIndicesCount(), remoteResponse.getIndicesBytes(), remoteResponse.getHeapBytes(), remoteResponse.getMemBytes());
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("cluster_uuid", this.clusterUUID);
            builder.field("mode", this.mode);
            if (this.skipUnavailable.isPresent()) {
                builder.field("skip_unavailable", this.skipUnavailable.get());
            }
            builder.field("transport.compress", this.transportCompress);
            builder.field("status", this.status);
            builder.field("version", (Collection<String>)this.versions);
            builder.field("nodes_count", this.nodesCount);
            builder.field("shards_count", this.shardsCount);
            builder.field("indices_count", this.indicesCount);
            builder.humanReadableField("indices_total_size_in_bytes", "indices_total_size", ByteSizeValue.ofBytes(this.indicesBytes));
            builder.humanReadableField("max_heap_in_bytes", "max_heap", ByteSizeValue.ofBytes(this.heapBytes));
            builder.humanReadableField("mem_total_in_bytes", "mem_total", ByteSizeValue.ofBytes(this.memBytes));
            builder.endObject();
            return builder;
        }
    }
}

