/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.util;

import co.elastic.logstash.api.Event;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.FieldReference;

public class EventUtil {
    private static final Logger LOGGER = LogManager.getLogger(EventUtil.class);

    private EventUtil() {
    }

    public static String safeExtractString(Event event, String fieldReference) {
        return EventUtil.safeExtractValue(event, fieldReference, String.class);
    }

    static <T> T safeExtractValue(Event event, String fieldReference, Class<T> tClass) {
        if (!event.includes(fieldReference)) {
            LOGGER.trace(() -> String.format("field `%s` not present on event", fieldReference));
            return null;
        }
        Object fieldValue = event.getField(fieldReference);
        if (Objects.isNull(fieldValue)) {
            LOGGER.trace(() -> String.format("field `%s` contained null-value", fieldReference));
            return null;
        }
        if (!tClass.isAssignableFrom(fieldValue.getClass())) {
            LOGGER.trace(() -> String.format("field `%s` value was of type `%s` and cannot be assigned to `%s`", fieldReference, fieldValue.getClass(), tClass));
            return null;
        }
        return tClass.cast(fieldValue);
    }

    public static String ensureValidFieldReference(String fieldReference, String descriptor) {
        if (!FieldReference.isValid((String)fieldReference)) {
            throw new IllegalArgumentException(String.format("Invalid field reference for `%s`: `%s`", descriptor, fieldReference));
        }
        return fieldReference;
    }

    public static String serializeEventForLog(Logger logger, Event event) {
        if (logger.isTraceEnabled()) {
            return String.format("Event{%s}", EventUtil.eventAsMap(event));
        }
        return event.toString();
    }

    public static Map<String, Object> eventAsMap(Event event) {
        Event eventClone = event.clone();
        HashMap intermediate = new HashMap(eventClone.toMap());
        intermediate.put("@metadata", Map.copyOf(eventClone.getMetadata()));
        return Collections.unmodifiableMap(intermediate);
    }
}

