/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceChunkingSettings
implements JsonpSerializable {
    @Nullable
    private final Integer maxChunkSize;
    @Nullable
    private final Integer overlap;
    @Nullable
    private final Integer sentenceOverlap;
    @Nullable
    private final String strategy;
    public static final JsonpDeserializer<InferenceChunkingSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceChunkingSettings::setupInferenceChunkingSettingsDeserializer);

    private InferenceChunkingSettings(Builder builder) {
        this.maxChunkSize = builder.maxChunkSize;
        this.overlap = builder.overlap;
        this.sentenceOverlap = builder.sentenceOverlap;
        this.strategy = builder.strategy;
    }

    public static InferenceChunkingSettings of(Function<Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer maxChunkSize() {
        return this.maxChunkSize;
    }

    @Nullable
    public final Integer overlap() {
        return this.overlap;
    }

    @Nullable
    public final Integer sentenceOverlap() {
        return this.sentenceOverlap;
    }

    @Nullable
    public final String strategy() {
        return this.strategy;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxChunkSize != null) {
            generator.writeKey("max_chunk_size");
            generator.write(this.maxChunkSize);
        }
        if (this.overlap != null) {
            generator.writeKey("overlap");
            generator.write(this.overlap);
        }
        if (this.sentenceOverlap != null) {
            generator.writeKey("sentence_overlap");
            generator.write(this.sentenceOverlap);
        }
        if (this.strategy != null) {
            generator.writeKey("strategy");
            generator.write(this.strategy);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceChunkingSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxChunkSize, JsonpDeserializer.integerDeserializer(), "max_chunk_size");
        op.add(Builder::overlap, JsonpDeserializer.integerDeserializer(), "overlap");
        op.add(Builder::sentenceOverlap, JsonpDeserializer.integerDeserializer(), "sentence_overlap");
        op.add(Builder::strategy, JsonpDeserializer.stringDeserializer(), "strategy");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceChunkingSettings> {
        @Nullable
        private Integer maxChunkSize;
        @Nullable
        private Integer overlap;
        @Nullable
        private Integer sentenceOverlap;
        @Nullable
        private String strategy;

        public final Builder maxChunkSize(@Nullable Integer value) {
            this.maxChunkSize = value;
            return this;
        }

        public final Builder overlap(@Nullable Integer value) {
            this.overlap = value;
            return this;
        }

        public final Builder sentenceOverlap(@Nullable Integer value) {
            this.sentenceOverlap = value;
            return this;
        }

        public final Builder strategy(@Nullable String value) {
            this.strategy = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceChunkingSettings build() {
            this._checkSingleUse();
            return new InferenceChunkingSettings(this);
        }
    }
}

