/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.TokenPruningConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SparseVectorIndexOptions
implements JsonpSerializable {
    @Nullable
    private final Boolean prune;
    @Nullable
    private final TokenPruningConfig pruningConfig;
    public static final JsonpDeserializer<SparseVectorIndexOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SparseVectorIndexOptions::setupSparseVectorIndexOptionsDeserializer);

    private SparseVectorIndexOptions(Builder builder) {
        this.prune = builder.prune;
        this.pruningConfig = builder.pruningConfig;
    }

    public static SparseVectorIndexOptions of(Function<Builder, ObjectBuilder<SparseVectorIndexOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean prune() {
        return this.prune;
    }

    @Nullable
    public final TokenPruningConfig pruningConfig() {
        return this.pruningConfig;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.prune != null) {
            generator.writeKey("prune");
            generator.write(this.prune);
        }
        if (this.pruningConfig != null) {
            generator.writeKey("pruning_config");
            this.pruningConfig.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSparseVectorIndexOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::prune, JsonpDeserializer.booleanDeserializer(), "prune");
        op.add(Builder::pruningConfig, TokenPruningConfig._DESERIALIZER, "pruning_config");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SparseVectorIndexOptions> {
        @Nullable
        private Boolean prune;
        @Nullable
        private TokenPruningConfig pruningConfig;

        public final Builder prune(@Nullable Boolean value) {
            this.prune = value;
            return this;
        }

        public final Builder pruningConfig(@Nullable TokenPruningConfig value) {
            this.pruningConfig = value;
            return this;
        }

        public final Builder pruningConfig(Function<TokenPruningConfig.Builder, ObjectBuilder<TokenPruningConfig>> fn) {
            return this.pruningConfig(fn.apply(new TokenPruningConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SparseVectorIndexOptions build() {
            this._checkSingleUse();
            return new SparseVectorIndexOptions(this);
        }
    }
}

