/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CompoundWordTokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HyphenationDecompounderTokenFilter
extends CompoundWordTokenFilterBase
implements TokenFilterDefinitionVariant {
    private final String hyphenationPatternsPath;
    @Nullable
    private final Boolean noSubMatches;
    @Nullable
    private final Boolean noOverlappingMatches;
    public static final JsonpDeserializer<HyphenationDecompounderTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HyphenationDecompounderTokenFilter::setupHyphenationDecompounderTokenFilterDeserializer);

    private HyphenationDecompounderTokenFilter(Builder builder) {
        super(builder);
        this.hyphenationPatternsPath = ApiTypeHelper.requireNonNull(builder.hyphenationPatternsPath, this, "hyphenationPatternsPath");
        this.noSubMatches = builder.noSubMatches;
        this.noOverlappingMatches = builder.noOverlappingMatches;
    }

    public static HyphenationDecompounderTokenFilter of(Function<Builder, ObjectBuilder<HyphenationDecompounderTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.HyphenationDecompounder;
    }

    public final String hyphenationPatternsPath() {
        return this.hyphenationPatternsPath;
    }

    @Nullable
    public final Boolean noSubMatches() {
        return this.noSubMatches;
    }

    @Nullable
    public final Boolean noOverlappingMatches() {
        return this.noOverlappingMatches;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "hyphenation_decompounder");
        super.serializeInternal(generator, mapper);
        generator.writeKey("hyphenation_patterns_path");
        generator.write(this.hyphenationPatternsPath);
        if (this.noSubMatches != null) {
            generator.writeKey("no_sub_matches");
            generator.write(this.noSubMatches);
        }
        if (this.noOverlappingMatches != null) {
            generator.writeKey("no_overlapping_matches");
            generator.write(this.noOverlappingMatches);
        }
    }

    protected static void setupHyphenationDecompounderTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        CompoundWordTokenFilterBase.setupCompoundWordTokenFilterBaseDeserializer(op);
        op.add(Builder::hyphenationPatternsPath, JsonpDeserializer.stringDeserializer(), "hyphenation_patterns_path");
        op.add(Builder::noSubMatches, JsonpDeserializer.booleanDeserializer(), "no_sub_matches");
        op.add(Builder::noOverlappingMatches, JsonpDeserializer.booleanDeserializer(), "no_overlapping_matches");
        op.ignore("type");
    }

    public static class Builder
    extends CompoundWordTokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HyphenationDecompounderTokenFilter> {
        private String hyphenationPatternsPath;
        @Nullable
        private Boolean noSubMatches;
        @Nullable
        private Boolean noOverlappingMatches;

        public final Builder hyphenationPatternsPath(String value) {
            this.hyphenationPatternsPath = value;
            return this;
        }

        public final Builder noSubMatches(@Nullable Boolean value) {
            this.noSubMatches = value;
            return this;
        }

        public final Builder noOverlappingMatches(@Nullable Boolean value) {
            this.noOverlappingMatches = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HyphenationDecompounderTokenFilter build() {
            this._checkSingleUse();
            return new HyphenationDecompounderTokenFilter(this);
        }
    }
}

