/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filewatch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import jnr.ffi.Runtime;
import jnr.posix.HANDLE;
import jnr.posix.JavaLibCHelper;
import jnr.posix.POSIX;
import jnr.posix.WindowsLibC;
import jnr.posix.WindowsPOSIX;
import jnr.posix.util.WindowsHelpers;
import jnr.posix.windows.WindowsByHandleFileInformation;
import jnr.posix.windows.WindowsFileInformationByHandle;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.OpenFile;
import org.logstash.filewatch.RubyWinIO;
import org.logstash.filewatch.WatchedFilesCollection;

public class JrubyFileWatchLibrary
implements Library {
    private static final BigInteger INIT32 = new BigInteger("811c9dc5", 16);
    private static final BigInteger INIT64 = new BigInteger("cbf29ce484222325", 16);
    private static final BigInteger PRIME32 = new BigInteger("01000193", 16);
    private static final BigInteger PRIME64 = new BigInteger("100000001b3", 16);
    private static final BigInteger MOD32 = new BigInteger("2").pow(32);
    private static final BigInteger MOD64 = new BigInteger("2").pow(64);
    private static final int GENERIC_READ = Integer.MIN_VALUE;
    private static final int FILE_SHARE_READ = 1;
    private static final int FILE_SHARE_WRITE = 2;
    private static final int OPEN_EXISTING = 3;
    private static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;

    public final void load(Ruby runtime, boolean wrap) {
        RubyModule module = runtime.defineModule("FileWatch");
        RubyClass clazz = runtime.defineClassUnder("FileExt", runtime.getObject(), RubyFileExt::new, module);
        clazz.defineAnnotatedMethods(RubyFileExt.class);
        clazz = runtime.defineClassUnder("Fnv", runtime.getObject(), Fnv::new, module);
        clazz.defineAnnotatedMethods(Fnv.class);
        WatchedFilesCollection.load(runtime);
    }

    @JRubyClass(name={"FileExt"})
    public static class RubyFileExt
    extends RubyObject {
        public RubyFileExt(Ruby runtime, RubyClass meta) {
            super(runtime, meta);
        }

        public RubyFileExt(RubyClass meta) {
            super(meta);
        }

        @JRubyMethod(name={"open"}, required=1, meta=true)
        public static IRubyObject open(ThreadContext context, IRubyObject self, RubyString path) throws IOException {
            Path javapath = FileSystems.getDefault().getPath(path.asJavaString(), new String[0]);
            FileChannel channel = FileChannel.open(javapath, StandardOpenOption.READ);
            RubyWinIO irubyobject = new RubyWinIO(context.runtime, channel);
            return irubyobject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"io_handle"}, required=1, meta=true)
        public static IRubyObject ioHandle(ThreadContext context, IRubyObject self, IRubyObject object, Block block) {
            Ruby runtime;
            block7: {
                runtime = context.runtime;
                if (!block.isGiven()) {
                    throw runtime.newArgumentError(0, 1);
                }
                if (object instanceof RubyWinIO) {
                    RubyWinIO rubyWinIO = (RubyWinIO)object;
                    OpenFile fptr = rubyWinIO.getOpenFileChecked();
                    boolean locked = fptr.lock();
                    try {
                        fptr.checkClosed();
                        if (rubyWinIO.isDirect()) {
                            MemoryIO memoryio = Factory.getInstance().wrapDirectMemory(runtime, rubyWinIO.getAddress());
                            Pointer pointer = new Pointer(runtime, memoryio);
                            IRubyObject iRubyObject = block.yield(context, (IRubyObject)pointer);
                            return iRubyObject;
                        }
                        break block7;
                    }
                    finally {
                        if (locked) {
                            fptr.unlock();
                        }
                    }
                }
                System.out.println("Required argument is not a WinIO instance");
            }
            return runtime.newString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RubyString ioInode(ThreadContext context, IRubyObject self, IRubyObject object) {
            Ruby runtime = context.runtime;
            if (!(object instanceof RubyIO)) {
                System.out.println("Required argument is not an IO instance");
                return runtime.newString();
            }
            RubyIO rubyIO = (RubyIO)object;
            OpenFile fptr = rubyIO.getOpenFileChecked();
            boolean locked = fptr.lock();
            String inode = "";
            try {
                fptr.checkClosed();
                POSIX posix = runtime.getPosix();
                int realFileno = fptr.fd().realFileno;
                if (posix.isNative() && posix instanceof WindowsPOSIX && realFileno != -1) {
                    WindowsPOSIX winposix = (WindowsPOSIX)posix;
                    WindowsLibC wlibc = (WindowsLibC)winposix.libc();
                    WindowsFileInformationByHandle info = new WindowsFileInformationByHandle(Runtime.getRuntime((Object)runtime.getPosix().libc()));
                    HANDLE handle = JavaLibCHelper.gethandle((FileDescriptor)JavaLibCHelper.getDescriptorFromChannel((Channel)fptr.fd().chFile));
                    if (handle.isValid()) {
                        if (wlibc.GetFileInformationByHandle(handle, (WindowsByHandleFileInformation)info) > 0) {
                            inode = info.getIdentifier();
                        } else {
                            System.out.println("Could not 'GetFileInformationByHandle' from handle");
                        }
                    } else {
                        System.out.println("Could not derive 'HANDLE' from Ruby IO instance via io.getOpenFileChecked().fd().chFile");
                    }
                }
            }
            finally {
                if (locked) {
                    fptr.unlock();
                }
            }
            return runtime.newString(inode);
        }

        public static RubyString pathInode(ThreadContext context, IRubyObject self, RubyString path) {
            Ruby runtime = context.runtime;
            POSIX posix = runtime.getPosix();
            String inode = "";
            if (posix.isNative() && posix.libc() instanceof WindowsLibC) {
                byte[] wpath;
                WindowsLibC wlibc = (WindowsLibC)posix.libc();
                HANDLE handle = wlibc.CreateFileW(wpath = WindowsHelpers.toWPath((String)path.toString()), Integer.MIN_VALUE, 3, null, 3, 0x2000000, 0);
                if (handle.isValid()) {
                    WindowsFileInformationByHandle info = new WindowsFileInformationByHandle(Runtime.getRuntime((Object)runtime.getPosix().libc()));
                    if (wlibc.GetFileInformationByHandle(handle, (WindowsByHandleFileInformation)info) > 0) {
                        inode = info.getIdentifier();
                    } else {
                        System.out.println("Could not 'GetFileInformationByHandle' from handle");
                    }
                    wlibc.CloseHandle(handle);
                } else {
                    System.out.printf("Could not open file via 'CreateFileW' on path: %s", path.toString());
                }
            }
            return runtime.newString(inode);
        }
    }

    @JRubyClass(name={"Fnv"})
    public static class Fnv
    extends RubyObject {
        private byte[] bytes;
        private long size;
        private boolean open;

        public Fnv(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        public Fnv(RubyClass metaClass) {
            super(metaClass);
        }

        @JRubyMethod(name={"coerce_bignum"}, meta=true, required=1)
        public static IRubyObject coerceBignum(ThreadContext ctx, IRubyObject recv, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyBignum) {
                return rubyObject;
            }
            if (rubyObject instanceof RubyFixnum) {
                return RubyBignum.newBignum((Ruby)ctx.runtime, (BigInteger)((RubyNumeric)rubyObject).getBigIntegerValue());
            }
            throw ctx.runtime.newRaiseException(ctx.runtime.getClass("StandardError"), "Can't coerce");
        }

        @JRubyMethod(name={"initialize"}, required=1)
        public IRubyObject rubyInitialize(ThreadContext ctx, RubyString data) {
            this.bytes = data.getBytes();
            this.size = this.bytes.length;
            this.open = true;
            return ctx.nil;
        }

        @JRubyMethod(name={"close"})
        public IRubyObject close(ThreadContext ctx) {
            this.open = false;
            this.bytes = null;
            return ctx.nil;
        }

        @JRubyMethod(name={"open?"})
        public IRubyObject open_p(ThreadContext ctx) {
            if (this.open) {
                return ctx.runtime.getTrue();
            }
            return ctx.runtime.getFalse();
        }

        @JRubyMethod(name={"closed?"})
        public IRubyObject closed_p(ThreadContext ctx) {
            if (this.open) {
                return ctx.runtime.getFalse();
            }
            return ctx.runtime.getTrue();
        }

        @JRubyMethod(name={"fnv1a32"}, optional=1)
        public IRubyObject fnv1a_32(ThreadContext ctx, IRubyObject[] args) {
            IRubyObject[] args1 = args;
            if (this.open) {
                args1 = Arity.scanArgs((Ruby)ctx.runtime, (IRubyObject[])args1, (int)0, (int)1);
                return RubyBignum.newBignum((Ruby)ctx.runtime, (BigInteger)this.common_fnv(args1[0], INIT32, PRIME32, MOD32));
            }
            throw ctx.runtime.newRaiseException(ctx.runtime.getClass("StandardError"), "Fnv instance is closed!");
        }

        @JRubyMethod(name={"fnv1a64"}, optional=1)
        public IRubyObject fnv1a_64(ThreadContext ctx, IRubyObject[] args) {
            IRubyObject[] args1 = args;
            if (this.open) {
                args1 = Arity.scanArgs((Ruby)ctx.runtime, (IRubyObject[])args1, (int)0, (int)1);
                return RubyBignum.newBignum((Ruby)ctx.runtime, (BigInteger)this.common_fnv(args1[0], INIT64, PRIME64, MOD64));
            }
            throw ctx.runtime.newRaiseException(ctx.runtime.getClass("StandardError"), "Fnv instance is closed!");
        }

        private long convertLong(IRubyObject obj) {
            if (obj instanceof RubyNumeric) {
                return ((RubyNumeric)obj).getLongValue();
            }
            return this.size;
        }

        private BigInteger common_fnv(IRubyObject len, BigInteger hash, BigInteger prime, BigInteger mod) {
            long converted = this.convertLong(len);
            if (converted > this.size) {
                converted = this.size;
            }
            BigInteger tempHash = hash;
            int idx = 0;
            while ((long)idx < converted) {
                tempHash = tempHash.xor(BigInteger.valueOf(this.bytes[idx] & 0xFF));
                tempHash = tempHash.multiply(prime).mod(mod);
                ++idx;
            }
            return tempHash;
        }
    }
}

