/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding;

import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.util.Counter;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.ContinuousFeatureValue;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.FeatureExtractor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.FeatureValue;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.ScriptDetector;

public class RelevantScriptFeatureExtractor
implements FeatureExtractor {
    @Override
    public FeatureValue[] extractFeatures(String text) {
        if (text.isEmpty()) {
            return new FeatureValue[0];
        }
        Counter totalCount = Counter.newCounter();
        TreeMap counts = new TreeMap();
        text.codePoints().forEach(cp -> {
            if (Character.isLetter(cp) || cp > 127) {
                ScriptDetector.Script script = ScriptDetector.Script.fromCodePoint(cp);
                counts.computeIfAbsent(script, s -> Counter.newCounter()).addAndGet(1L);
                totalCount.addAndGet(1L);
            }
        });
        FeatureValue[] result = new FeatureValue[counts.size()];
        int index = 0;
        for (Map.Entry entry : counts.entrySet()) {
            ScriptDetector.Script scriptId = (ScriptDetector.Script)((Object)entry.getKey());
            long count = ((Counter)entry.getValue()).get();
            double weight = (double)count / (double)totalCount.get();
            result[index++] = new ContinuousFeatureValue(scriptId.toInt(), weight);
        }
        return result;
    }
}

