/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.constantkeyword.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.constantkeyword.ConstantKeywordDocValuesField;
import org.elasticsearch.xpack.core.termsenum.action.SimpleTermCountEnum;

public class ConstantKeywordFieldMapper
extends FieldMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(ConstantKeywordFieldMapper.class);
    public static final String CONTENT_TYPE = "constant_keyword";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));

    private static ConstantKeywordFieldMapper toType(FieldMapper in) {
        return (ConstantKeywordFieldMapper)in;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    ConstantKeywordFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams) {
        super(simpleName, mappedFieldType, builderParams);
    }

    @Override
    public ConstantKeywordFieldType fieldType() {
        return (ConstantKeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String value = parser.textOrNull();
        if (value == null) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.fullPath() + "] doesn't accept [null] values");
        }
        if (this.fieldType().value == null) {
            ConstantKeywordFieldType newFieldType = new ConstantKeywordFieldType(this.fieldType().name(), value, this.fieldType().meta());
            ConstantKeywordFieldMapper update = new ConstantKeywordFieldMapper(this.leafName(), newFieldType, this.builderParams);
            boolean dynamicMapperAdded = context.addDynamicMapper(update);
            assert (dynamicMapperAdded);
        } else if (!Objects.equals(this.fieldType().value, value)) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.fullPath() + "] only accepts values that are equal to the value defined in the mappings [" + this.fieldType().value() + "], but got [" + value + "]");
        }
        if (context.mappingLookup().isSourceSynthetic()) {
            context.doc().add(new SortedNumericDocValuesField(this.fieldType().name(), 1L));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        final String const_value = this.fieldType().value();
        if (const_value == null) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> SourceLoader.SyntheticFieldLoader.NOTHING);
        }
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new SortedNumericDocValuesSyntheticFieldLoader(this, this.fullPath(), this.leafName(), false){

            @Override
            protected void writeValue(XContentBuilder b, long ignored) throws IOException {
                b.value(const_value);
            }
        });
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<String> value = new FieldMapper.Parameter<String>("value", true, () -> null, (n, c, o) -> {
            if (!(o instanceof Number) && !(o instanceof CharSequence)) {
                throw new MapperParsingException("Property [value] on field [" + n + "] must be a number or a string, but got [" + String.valueOf(o) + "]");
            }
            return o.toString();
        }, m -> ConstantKeywordFieldMapper.toType((FieldMapper)m).fieldType().value, XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
            this.value.setSerializerCheck((id, ic, v) -> v != null);
            this.value.setMergeValidator((previous, current, c) -> previous == null || Objects.equals(previous, current));
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.value, this.meta};
        }

        @Override
        public ConstantKeywordFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "constant_keyword_multifields", "Adding multifields to [constant_keyword] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            return new ConstantKeywordFieldMapper(this.leafName(), new ConstantKeywordFieldType(context.buildFullName(this.leafName()), this.value.getValue(), this.meta.getValue()), this.builderParams(this, context));
        }
    }

    public static final class ConstantKeywordFieldType
    extends ConstantFieldType {
        private final String value;

        public ConstantKeywordFieldType(String name, String value, Map<String, String> meta) {
            super(name, meta);
            this.value = value;
        }

        public ConstantKeywordFieldType(String name, String value) {
            this(name, value, Collections.emptyMap());
        }

        public String value() {
            return this.value;
        }

        @Override
        public String typeName() {
            return ConstantKeywordFieldMapper.CONTENT_TYPE;
        }

        @Override
        public String familyTypeName() {
            return "keyword";
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.value == null) {
                return BlockLoader.CONSTANT_NULLS;
            }
            return BlockLoader.constantBytes(new BytesRef(this.value));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return new ConstantIndexFieldData.Builder(this.value, this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new ConstantKeywordDocValuesField(FieldData.toString(dv), n));
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return this.value == null ? ValueFetcher.EMPTY : ValueFetcher.singleton(this.value);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        public TermsEnum getTerms(IndexReader reader, String prefix, boolean caseInsensitive, String searchAfter) {
            boolean matches;
            if (this.value == null) {
                return TermsEnum.EMPTY;
            }
            boolean bl = matches = caseInsensitive ? this.value.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT)) : this.value.startsWith(prefix);
            if (!matches) {
                return TermsEnum.EMPTY;
            }
            if (searchAfter != null && searchAfter.compareTo(this.value) >= 0) {
                return TermsEnum.EMPTY;
            }
            return new SimpleTermCountEnum(this.value);
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryRewriteContext context) {
            if (this.value == null) {
                return false;
            }
            return Regex.simpleMatch(pattern, this.value, caseInsensitive);
        }

        @Override
        public String getConstantFieldValue(SearchExecutionContext context) {
            return this.value;
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return this.value != null ? new MatchAllDocsQuery() : new MatchNoDocsQuery();
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            BytesRef valueAsBytesRef = new BytesRef(this.value);
            if (lowerTerm != null && BytesRefs.toBytesRef(lowerTerm).compareTo(valueAsBytesRef) >= (includeLower ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            if (upperTerm != null && valueAsBytesRef.compareTo(BytesRefs.toBytesRef(upperTerm)) >= (includeUpper ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        @Override
        public Query fuzzyQuery(Object term, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            String prefix;
            int cp;
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            String termAsString = BytesRefs.toString(term);
            int maxEdits = fuzziness.asDistance(termAsString);
            int[] termText = new int[termAsString.codePointCount(0, termAsString.length())];
            int j = 0;
            for (int i = 0; i < termAsString.length(); i += Character.charCount(cp)) {
                termText[j++] = cp = termAsString.codePointAt(i);
            }
            int termLength = termText.length;
            String suffix = UnicodeUtil.newString(termText, prefixLength = Math.min(prefixLength, termLength), termText.length - prefixLength);
            LevenshteinAutomata builder = new LevenshteinAutomata(suffix, transpositions);
            Automaton automaton = builder.toAutomaton(maxEdits, prefix = UnicodeUtil.newString(termText, 0, prefixLength));
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }

        @Override
        public Query regexpQuery(String regexp, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            Automaton automaton = Operations.determinize(new RegExp(regexp, syntaxFlags, matchFlags).toAutomaton(), maxDeterminizedStates);
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }
    }
}

