/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.injection.PlanInterpreter;
import org.elasticsearch.injection.Planner;
import org.elasticsearch.injection.api.Inject;
import org.elasticsearch.injection.spec.ExistingInstanceSpec;
import org.elasticsearch.injection.spec.InjectionSpec;
import org.elasticsearch.injection.spec.MethodHandleSpec;
import org.elasticsearch.injection.spec.ParameterSpec;
import org.elasticsearch.injection.step.InjectionStep;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public final class Injector {
    private static final Logger logger = LogManager.getLogger(Injector.class);
    private final Map<Class<?>, InjectionSpec> seedSpecs;

    Injector(Map<Class<?>, InjectionSpec> seedSpecs) {
        this.seedSpecs = seedSpecs;
    }

    public static Injector create() {
        return new Injector(new LinkedHashMap());
    }

    public Injector addClass(Class<?> classToProcess) {
        MethodHandleSpec methodHandleSpec = Injector.methodHandleSpecFor(classToProcess);
        InjectionSpec existing = this.seedSpecs.put(classToProcess, methodHandleSpec);
        if (existing != null) {
            throw new IllegalArgumentException("class " + classToProcess.getSimpleName() + " has already been added");
        }
        return this;
    }

    public Injector addClasses(Collection<Class<?>> classesToProcess) {
        classesToProcess.forEach(this::addClass);
        return this;
    }

    public <T> Injector addInstance(Object object) {
        Class<?> actualClass = object.getClass();
        return this.addInstance(actualClass, actualClass.cast(object));
    }

    public Injector addInstances(Collection<?> objects) {
        for (Object x : objects) {
            this.addInstance(x);
        }
        return this;
    }

    public <T> Injector addInstance(Class<? super T> type, T object) {
        assert (type.isInstance(object));
        InjectionSpec existing = this.seedSpecs.put(type, new ExistingInstanceSpec(type, object));
        if (existing != null) {
            throw new IllegalStateException("There's already an object for " + String.valueOf(type));
        }
        return this;
    }

    public Map<Class<?>, Object> inject(Collection<? extends Class<?>> resultTypes) {
        resultTypes.forEach(this::ensureClassIsSpecified);
        PlanInterpreter i = this.doInjection();
        return resultTypes.stream().collect(Collectors.toMap(c -> c, i::theInstanceOf));
    }

    private <T> void ensureClassIsSpecified(Class<T> resultType) {
        if (!this.seedSpecs.containsKey(resultType)) {
            this.addClass(resultType);
        }
    }

    private PlanInterpreter doInjection() {
        logger.debug("Starting injection");
        Map<Class<?>, InjectionSpec> specMap = Injector.specClosure(this.seedSpecs);
        LinkedHashMap existingInstances = new LinkedHashMap();
        specMap.values().forEach(spec -> {
            if (spec instanceof ExistingInstanceSpec) {
                ExistingInstanceSpec e = (ExistingInstanceSpec)spec;
                existingInstances.put(e.requestedType(), e.instance());
            }
        });
        PlanInterpreter interpreter = new PlanInterpreter(existingInstances);
        interpreter.executePlan(this.injectionPlan(this.seedSpecs.keySet(), specMap));
        logger.debug("Done injection");
        return interpreter;
    }

    private static Map<Class<?>, InjectionSpec> specClosure(Map<Class<?>, InjectionSpec> seedMap) {
        ParameterSpec p;
        assert (Injector.seedMapIsValid(seedMap));
        Queue workQueue = seedMap.values().stream().map(InjectionSpec::requestedType).map(Injector::syntheticParameterSpec).collect(Collectors.toCollection(ArrayDeque::new));
        LinkedHashMap result = new LinkedHashMap();
        while ((p = (ParameterSpec)workQueue.poll()) != null) {
            MethodHandleSpec methodHandleSpec;
            Class<?> c = p.injectableType();
            InjectionSpec existingResult = (InjectionSpec)result.get(c);
            if (existingResult != null) {
                logger.trace("Spec for {} already exists", c.getSimpleName());
                continue;
            }
            InjectionSpec spec = seedMap.get(c);
            if (spec instanceof ExistingInstanceSpec) {
                result.put(c, spec);
                continue;
            }
            if (spec == null) {
                methodHandleSpec = Injector.methodHandleSpecFor(c);
                spec = methodHandleSpec;
            } else if (spec instanceof MethodHandleSpec) {
                MethodHandleSpec m;
                methodHandleSpec = m = (MethodHandleSpec)spec;
            } else {
                throw new AssertionError((Object)("Unexpected spec: " + String.valueOf(spec)));
            }
            logger.trace("Inspecting parameters for constructor of {}", c);
            for (ParameterSpec ps : methodHandleSpec.parameters()) {
                logger.trace("Enqueue {}", ps);
                workQueue.add(ps);
            }
            Injector.registerSpec(spec, result);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Specs: {}", result.values().stream().map(Object::toString).collect(Collectors.joining("\n\t", "\n\t", "")));
        }
        return result;
    }

    private static MethodHandleSpec methodHandleSpecFor(Class<?> c) {
        MethodHandle ctorHandle;
        Constructor<?> constructor = Injector.getSuitableConstructorIfAny(c);
        if (constructor == null) {
            throw new IllegalStateException("No suitable constructor for " + String.valueOf(c));
        }
        try {
            ctorHandle = Injector.lookup().unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        List<ParameterSpec> parameters = Stream.of(constructor.getParameters()).map(ParameterSpec::from).toList();
        return new MethodHandleSpec(c, ctorHandle, parameters);
    }

    private static boolean seedMapIsValid(Map<Class<?>, InjectionSpec> seed) {
        seed.forEach((c, s) -> {
            assert (s.requestedType().equals(c)) : "Spec must be associated with its requestedType, not " + String.valueOf(c) + ": " + String.valueOf(s);
        });
        return true;
    }

    private static ParameterSpec syntheticParameterSpec(Class<?> c) {
        return new ParameterSpec("synthetic_" + c.getSimpleName(), c, c);
    }

    private static Constructor<?> getSuitableConstructorIfAny(Class<?> type) {
        List<Constructor> constructors = Stream.of(type.getConstructors()).filter(Predicate.not(Constructor::isSynthetic)).toList();
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        List<Constructor> injectConstructors = constructors.stream().filter(c -> c.isAnnotationPresent(Inject.class)).toList();
        if (injectConstructors.size() == 1) {
            return injectConstructors.get(0);
        }
        logger.trace("No suitable constructor for {}", type);
        return null;
    }

    private static void registerSpec(InjectionSpec spec, Map<Class<?>, InjectionSpec> specsByClass) {
        Class<?> requestedType = spec.requestedType();
        InjectionSpec existing = specsByClass.put(requestedType, spec);
        if (existing != null && !existing.equals(spec)) {
            throw new IllegalStateException("Ambiguous specifications for " + String.valueOf(requestedType) + ": " + String.valueOf(existing) + " and " + String.valueOf(spec));
        }
        logger.trace("Register spec: {}", spec);
    }

    private List<InjectionStep> injectionPlan(Set<Class<?>> requiredClasses, Map<Class<?>, InjectionSpec> specsByClass) {
        logger.trace("Constructing instantiation plan");
        HashSet allParameterTypes = new HashSet();
        specsByClass.values().forEach(spec -> {
            if (spec instanceof MethodHandleSpec) {
                MethodHandleSpec m = (MethodHandleSpec)spec;
                m.parameters().stream().map(ParameterSpec::injectableType).forEachOrdered(allParameterTypes::add);
            }
        });
        List<InjectionStep> plan = new Planner(specsByClass, requiredClasses, allParameterTypes).injectionPlan();
        if (logger.isDebugEnabled()) {
            logger.debug("Injection plan: {}", plan.stream().map(Object::toString).collect(Collectors.joining("\n\t", "\n\t", "")));
        }
        return plan;
    }

    private static MethodHandles.Lookup lookup() {
        return MethodHandles.publicLookup();
    }
}

