/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.engine.CombinedDocValues;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.MissingHistoryOperationsException;
import org.elasticsearch.index.engine.SearchBasedChangesSnapshot;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.search.lookup.Source;

public class LuceneSyntheticSourceChangesSnapshot
extends SearchBasedChangesSnapshot {
    private final long maxMemorySizeInBytes;
    private final StoredFieldLoader storedFieldLoader;
    private final SourceLoader sourceLoader;
    private int skippedOperations;
    private long lastSeenSeqNo;
    private final Deque<SearchRecord> pendingDocs = new LinkedList<SearchRecord>();
    private final Deque<Translog.Operation> operationQueue = new LinkedList<Translog.Operation>();

    public LuceneSyntheticSourceChangesSnapshot(MapperService mapperService, Engine.Searcher engineSearcher, int searchBatchSize, long maxMemorySizeInBytes, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accessStats, IndexVersion indexVersionCreated) throws IOException {
        super(mapperService, engineSearcher, searchBatchSize, fromSeqNo, toSeqNo, requiredFullRange, accessStats, indexVersionCreated);
        assert (engineSearcher.getDirectoryReader().maxDoc() == 0 || mapperService.mappingLookup().isSourceSynthetic()) : "either an empty index or synthetic source must be enabled for proper functionality.";
        this.maxMemorySizeInBytes = maxMemorySizeInBytes > 0L ? maxMemorySizeInBytes : 1L;
        this.sourceLoader = mapperService.mappingLookup().newSourceLoader(null, SourceFieldMetrics.NOOP);
        Set<String> storedFields = this.sourceLoader.requiredStoredFields();
        String defaultCodec = EngineConfig.INDEX_CODEC_SETTING.get(mapperService.getIndexSettings().getSettings());
        boolean forceSequentialReader = "best_compression".equals(defaultCodec);
        this.storedFieldLoader = StoredFieldLoader.create(false, storedFields, forceSequentialReader);
        this.lastSeenSeqNo = fromSeqNo - 1L;
    }

    @Override
    public int skippedOperations() {
        return this.skippedOperations;
    }

    @Override
    protected Translog.Operation nextOperation() throws IOException {
        Translog.Operation op;
        while (true) {
            if (this.operationQueue.isEmpty()) {
                this.loadNextBatch();
            }
            if (this.operationQueue.isEmpty()) {
                return null;
            }
            op = this.operationQueue.pollFirst();
            if (op.seqNo() != this.lastSeenSeqNo) break;
            ++this.skippedOperations;
        }
        this.lastSeenSeqNo = op.seqNo();
        return op;
    }

    private void loadNextBatch() throws IOException {
        SearchRecord document;
        ArrayList<SearchRecord> documentsToLoad = new ArrayList<SearchRecord>();
        for (long accumulatedSize = 0L; accumulatedSize < this.maxMemorySizeInBytes; accumulatedSize += document.size()) {
            if (this.pendingDocs.isEmpty()) {
                ScoreDoc[] topDocs = this.nextTopDocs().scoreDocs;
                if (topDocs.length == 0) break;
                this.pendingDocs.addAll(Arrays.asList(this.transformScoreDocsToRecords(topDocs)));
            }
            document = this.pendingDocs.pollFirst();
            document.doc().shardIndex = documentsToLoad.size();
            documentsToLoad.add(document);
        }
        for (Translog.Operation op : this.loadDocuments(documentsToLoad)) {
            if (op == null) {
                ++this.skippedOperations;
                continue;
            }
            this.operationQueue.add(op);
        }
    }

    private SearchRecord[] transformScoreDocsToRecords(ScoreDoc[] scoreDocs) throws IOException {
        ArrayUtil.introSort(scoreDocs, Comparator.comparingInt(doc -> doc.doc));
        SearchRecord[] documentRecords = new SearchRecord[scoreDocs.length];
        CombinedDocValues combinedDocValues = null;
        int docBase = -1;
        int maxDoc = 0;
        int readerIndex = 0;
        for (int i = 0; i < scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i];
            if (scoreDoc.doc >= docBase + maxDoc) {
                LeafReaderContext leafReaderContext;
                while (scoreDoc.doc >= (docBase = leafReaderContext.docBase) + (maxDoc = (leafReaderContext = this.leaves().get(readerIndex++)).reader().maxDoc())) {
                }
                combinedDocValues = new CombinedDocValues(leafReaderContext.reader());
            }
            int segmentDocID = scoreDoc.doc - docBase;
            int index = scoreDoc.shardIndex;
            long primaryTerm = combinedDocValues.docPrimaryTerm(segmentDocID);
            assert (primaryTerm > 0L) : "nested child document must be excluded";
            documentRecords[index] = new SearchRecord((FieldDoc)scoreDoc, combinedDocValues.isTombstone(segmentDocID), combinedDocValues.docSeqNo(segmentDocID), primaryTerm, combinedDocValues.docVersion(segmentDocID), combinedDocValues.recoverySourceSize(segmentDocID));
        }
        return documentRecords;
    }

    private Translog.Operation[] loadDocuments(List<SearchRecord> documentRecords) throws IOException {
        documentRecords.sort(Comparator.comparingInt(doc -> doc.docID()));
        Translog.Operation[] operations = new Translog.Operation[documentRecords.size()];
        int docBase = -1;
        int maxDoc = 0;
        int readerIndex = 0;
        LeafReaderContext leafReaderContext = null;
        LeafStoredFieldLoader leafFieldLoader = null;
        SourceLoader.Leaf leafSourceLoader = null;
        for (int i = 0; i < documentRecords.size(); ++i) {
            SearchRecord docRecord = documentRecords.get(i);
            if (docRecord.docID() >= docBase + maxDoc) {
                do {
                    leafReaderContext = this.leaves().get(readerIndex++);
                    docBase = leafReaderContext.docBase;
                    maxDoc = leafReaderContext.reader().maxDoc();
                } while (docRecord.docID() >= docBase + maxDoc);
                IntArrayList nextDocIds = new IntArrayList();
                for (int j = i; j < documentRecords.size(); ++j) {
                    SearchRecord record = documentRecords.get(j);
                    if (record.isTombstone()) continue;
                    int docID = record.docID();
                    if (docID >= docBase + maxDoc) break;
                    int segmentDocID = docID - docBase;
                    nextDocIds.add(segmentDocID);
                }
                int[] nextDocIdArray = nextDocIds.toArray();
                leafFieldLoader = this.storedFieldLoader.getLoader(leafReaderContext, nextDocIdArray);
                leafSourceLoader = this.sourceLoader.leaf(leafReaderContext.reader(), nextDocIdArray);
                this.setNextSyntheticFieldsReader(leafReaderContext);
            }
            int segmentDocID = docRecord.docID() - docBase;
            leafFieldLoader.advanceTo(segmentDocID);
            operations[docRecord.index()] = this.createOperation(docRecord, leafFieldLoader, leafSourceLoader, segmentDocID, leafReaderContext);
        }
        return operations;
    }

    private Translog.Operation createOperation(SearchRecord docRecord, LeafStoredFieldLoader fieldLoader, SourceLoader.Leaf sourceLoader, int segmentDocID, LeafReaderContext context) throws IOException {
        if (docRecord.isTombstone() && fieldLoader.id() == null) {
            assert (docRecord.version() == 1L) : "Noop tombstone should have version 1L; actual version [" + docRecord.version() + "]";
            assert (LuceneSyntheticSourceChangesSnapshot.assertDocSoftDeleted(context.reader(), segmentDocID)) : "Noop but soft_deletes field is not set [" + String.valueOf(docRecord) + "]";
            return new Translog.NoOp(docRecord.seqNo(), docRecord.primaryTerm(), "null");
        }
        if (docRecord.isTombstone()) {
            assert (LuceneSyntheticSourceChangesSnapshot.assertDocSoftDeleted(context.reader(), segmentDocID)) : "Delete op but soft_deletes field is not set [" + String.valueOf(docRecord) + "]";
            return new Translog.Delete(fieldLoader.id(), docRecord.seqNo(), docRecord.primaryTerm(), docRecord.version());
        }
        if (!docRecord.hasRecoverySourceSize()) {
            if (this.requiredFullRange) {
                throw new MissingHistoryOperationsException("source not found for seqno=" + docRecord.seqNo() + " from_seqno=" + this.fromSeqNo + " to_seqno=" + this.toSeqNo);
            }
            ++this.skippedOperations;
            return null;
        }
        Source source = this.addSyntheticFields(sourceLoader.source(fieldLoader, segmentDocID), segmentDocID);
        return new Translog.Index(fieldLoader.id(), docRecord.seqNo(), docRecord.primaryTerm(), docRecord.version(), source.internalSourceRef(), fieldLoader.routing(), -1L);
    }

    private record SearchRecord(FieldDoc doc, boolean isTombstone, long seqNo, long primaryTerm, long version, long size) {
        int index() {
            return this.doc.shardIndex;
        }

        int docID() {
            return this.doc.doc;
        }

        boolean hasRecoverySourceSize() {
            return this.size != -1L;
        }
    }
}

