/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;

public class ExpectedShardSizeEstimator {
    public static boolean shouldReserveSpaceForInitializingShard(ShardRouting shard, RoutingAllocation allocation) {
        return ExpectedShardSizeEstimator.shouldReserveSpaceForInitializingShard(shard, allocation.metadata());
    }

    public static long getExpectedShardSize(ShardRouting shard, long defaultSize, RoutingAllocation allocation) {
        ProjectMetadata project = allocation.metadata().projectFor(shard.index());
        return ExpectedShardSizeEstimator.getExpectedShardSize(shard, defaultSize, allocation.clusterInfo(), allocation.snapshotShardSizeInfo(), project, allocation.routingTable(project.id()));
    }

    public static boolean shouldReserveSpaceForInitializingShard(ShardRouting shard, Metadata metadata) {
        assert (shard.initializing()) : "Expected initializing shard, got: " + String.valueOf(shard);
        return switch (shard.recoverySource().getType()) {
            default -> throw new MatchException(null, null);
            case RecoverySource.Type.EMPTY_STORE -> false;
            case RecoverySource.Type.EXISTING_STORE -> false;
            case RecoverySource.Type.PEER -> true;
            case RecoverySource.Type.SNAPSHOT -> {
                if (!metadata.indexMetadata(shard.index()).isPartialSearchableSnapshot()) {
                    yield true;
                }
                yield false;
            }
            case RecoverySource.Type.LOCAL_SHARDS -> false;
            case RecoverySource.Type.RESHARD_SPLIT -> false;
        };
    }

    public static long getExpectedShardSize(ShardRouting shard, long defaultValue, ShardSizeProvider shardSizeProvider, SnapshotShardSizeInfo snapshotShardSizeInfo, ProjectMetadata projectMetadata, RoutingTable routingTable) {
        IndexMetadata indexMetadata = projectMetadata.getIndexSafe(shard.index());
        if (indexMetadata.getResizeSourceIndex() != null && !shard.active() && shard.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
            assert (shard.primary()) : "All replica shards are recovering from " + String.valueOf((Object)RecoverySource.Type.PEER);
            return ExpectedShardSizeEstimator.getExpectedSizeOfResizedShard(shard, defaultValue, indexMetadata, shardSizeProvider, projectMetadata, routingTable);
        }
        if (!shard.active() && shard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) {
            assert (shard.primary()) : "All replica shards are recovering from " + String.valueOf((Object)RecoverySource.Type.PEER);
            return snapshotShardSizeInfo.getShardSize(shard, defaultValue);
        }
        Long shardSize = shardSizeProvider.getShardSize(shard.shardId(), shard.primary());
        if (shardSize == null && !shard.primary()) {
            shardSize = shardSizeProvider.getShardSize(shard.shardId(), true);
        }
        return shardSize == null ? defaultValue : shardSize;
    }

    private static long getExpectedSizeOfResizedShard(ShardRouting shard, long defaultValue, IndexMetadata indexMetadata, ShardSizeProvider shardSizeProvider, ProjectMetadata projectMetadata, RoutingTable routingTable) {
        long targetShardSize = 0L;
        Index mergeSourceIndex = indexMetadata.getResizeSourceIndex();
        IndexMetadata sourceIndexMetadata = projectMetadata.index(mergeSourceIndex);
        if (sourceIndexMetadata != null) {
            Set<ShardId> shardIds = IndexMetadata.selectRecoverFromShards(shard.id(), sourceIndexMetadata, indexMetadata.getNumberOfShards());
            IndexRoutingTable indexRoutingTable = routingTable.index(mergeSourceIndex.getName());
            if (indexRoutingTable == null) {
                String error = "No routing table for index [" + String.valueOf(mergeSourceIndex) + "] in project [" + String.valueOf(projectMetadata.id()) + "]";
                assert (false) : error;
                throw new IllegalStateException(error);
            }
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(i);
                if (!shardIds.contains(shardRoutingTable.shardId())) continue;
                targetShardSize += shardSizeProvider.getShardSize(shardRoutingTable.primaryShard(), 0L);
            }
        }
        return targetShardSize == 0L ? defaultValue : targetShardSize;
    }

    public static interface ShardSizeProvider {
        public Long getShardSize(ShardId var1, boolean var2);

        default public Long getShardSize(ShardRouting shardRouting) {
            return this.getShardSize(shardRouting.shardId(), shardRouting.primary());
        }

        default public long getShardSize(ShardRouting shardRouting, long defaultValue) {
            Long shardSize = this.getShardSize(shardRouting);
            return shardSize == null ? defaultValue : shardSize;
        }

        default public long getShardSize(ShardId shardId, boolean primary, long defaultValue) {
            Long shardSize = this.getShardSize(shardId, primary);
            return shardSize == null ? defaultValue : shardSize;
        }
    }
}

