/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.FilterMatchListener;
import co.elastic.logstash.filters.elasticintegration.DatastreamEventToIndexNameResolver;
import co.elastic.logstash.filters.elasticintegration.ElasticsearchIndexNameToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.ElasticsearchPipelineConfigurationResolver;
import co.elastic.logstash.filters.elasticintegration.EventProcessor;
import co.elastic.logstash.filters.elasticintegration.EventToIndexNameResolver;
import co.elastic.logstash.filters.elasticintegration.EventToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.IndexNameToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.IngestPipeline;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineFactory;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.PipelineConfigurationResolver;
import co.elastic.logstash.filters.elasticintegration.PluginConfiguration;
import co.elastic.logstash.filters.elasticintegration.SimpleIngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.SprintfTemplateEventToPipelineNameResolver;
import co.elastic.logstash.filters.elasticintegration.ingest.SafeSubsetIngestPlugin;
import co.elastic.logstash.filters.elasticintegration.ingest.SetSecurityUserProcessor;
import co.elastic.logstash.filters.elasticintegration.ingest.SingleProcessorIngestPlugin;
import co.elastic.logstash.filters.elasticintegration.resolver.CacheReloadService;
import co.elastic.logstash.filters.elasticintegration.resolver.CachingResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.ResolverCache;
import co.elastic.logstash.filters.elasticintegration.resolver.SimpleCachingResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.SimpleResolverCache;
import co.elastic.logstash.filters.elasticintegration.util.Exceptions;
import co.elastic.logstash.filters.elasticintegration.util.PluginContext;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.ServiceManager;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.logstashbridge.common.SettingsBridge;
import org.elasticsearch.logstashbridge.core.IOUtilsBridge;
import org.elasticsearch.logstashbridge.env.EnvironmentBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorFactoryBridge;
import org.elasticsearch.logstashbridge.ingest.ProcessorParametersBridge;
import org.elasticsearch.logstashbridge.plugins.IngestCommonPluginBridge;
import org.elasticsearch.logstashbridge.plugins.IngestPluginBridge;
import org.elasticsearch.logstashbridge.plugins.IngestUserAgentPluginBridge;
import org.elasticsearch.logstashbridge.plugins.RedactPluginBridge;
import org.elasticsearch.logstashbridge.script.ScriptServiceBridge;
import org.elasticsearch.logstashbridge.threadpool.ThreadPoolBridge;

public class EventProcessorBuilder {
    static final Duration CACHE_MAXIMUM_AGE;
    static final Duration CACHE_RELOAD_FREQUENCY;
    private EventToPipelineNameResolver eventToPipelineNameResolver;
    private EventToIndexNameResolver eventToIndexNameResolver;
    private IndexNameToPipelineNameResolver indexNameToPipelineNameResolver;
    private Supplier<ResolverCache<String, String>> pipelineNameResolverCacheSupplier;
    private PipelineConfigurationResolver pipelineConfigurationResolver;
    private Supplier<ResolverCache<String, IngestPipeline>> ingestPipelineResolverCacheSupplier;
    private FilterMatchListener filterMatchListener;
    private final List<Supplier<IngestPluginBridge>> ingestPlugins = new ArrayList<Supplier<IngestPluginBridge>>();

    private static <K, V> Supplier<ResolverCache<K, V>> defaultCacheSupplier(String description) {
        return () -> new SimpleResolverCache(description, SimpleResolverCache.Configuration.PERMANENT);
    }

    public static EventProcessorBuilder fromElasticsearch(RestClient elasticsearchRestClient, PluginConfiguration pluginConfiguration) {
        EventProcessorBuilder builder = new EventProcessorBuilder();
        if (pluginConfiguration.pipelineNameTemplate().isPresent()) {
            builder.setEventPipelineNameResolver(SprintfTemplateEventToPipelineNameResolver.from(pluginConfiguration.pipelineNameTemplate().get()));
        }
        builder.setEventIndexNameResolver(new DatastreamEventToIndexNameResolver());
        builder.setIndexNamePipelineNameResolver(new ElasticsearchIndexNameToPipelineNameResolver(elasticsearchRestClient));
        builder.setPipelineNameResolverCacheConfig(CACHE_MAXIMUM_AGE, CACHE_MAXIMUM_AGE);
        builder.setPipelineConfigurationResolver(new ElasticsearchPipelineConfigurationResolver(elasticsearchRestClient));
        builder.setIngestPipelineResolverCacheConfig(CACHE_MAXIMUM_AGE, CACHE_MAXIMUM_AGE);
        return builder;
    }

    public EventProcessorBuilder() {
        this.addProcessorsFromPlugin(IngestCommonPluginBridge::new, Set.of("append", "bytes", "community_id", "convert", "csv", "date_index_name", "date", "dissect", "dot_expander", "drop", "fail", "fingerprint", "foreach", "grok", "gsub", "html_strip", "join", "json", "kv", "lowercase", "network_direction", "registered_domain", "remove", "rename", "reroute", "script", "set", "sort", "split", "terminate", "trim", "urldecode", "uppercase", "uri_parts"));
        this.addProcessorsFromPlugin(IngestUserAgentPluginBridge::new);
        this.addProcessorsFromPlugin(RedactPluginBridge::new);
        this.addProcessor("set_security_user", SetSecurityUserProcessor.Factory::new);
    }

    public synchronized EventProcessorBuilder setPipelineConfigurationResolver(PipelineConfigurationResolver pipelineConfigurationResolver) {
        if (Objects.nonNull(this.pipelineConfigurationResolver)) {
            throw new IllegalStateException("pipelineConfigurationResolver already set");
        }
        this.pipelineConfigurationResolver = pipelineConfigurationResolver;
        return this;
    }

    public EventProcessorBuilder setIngestPipelineResolverCacheConfig(Duration maxHitTtl, Duration maxMissTtl) {
        return this.setIngestPipelineResolverCacheSupplier(() -> new SimpleResolverCache("pipeline", new SimpleResolverCache.Configuration(maxHitTtl, maxMissTtl)));
    }

    public synchronized EventProcessorBuilder setIngestPipelineResolverCacheSupplier(Supplier<ResolverCache<String, IngestPipeline>> cacheSupplier) {
        this.ingestPipelineResolverCacheSupplier = cacheSupplier;
        return this;
    }

    public synchronized EventProcessorBuilder setEventPipelineNameResolver(EventToPipelineNameResolver eventToPipelineNameResolver) {
        if (Objects.nonNull(this.eventToPipelineNameResolver)) {
            throw new IllegalStateException("eventToPipelineNameResolver already set");
        }
        this.eventToPipelineNameResolver = eventToPipelineNameResolver;
        return this;
    }

    public synchronized EventProcessorBuilder setEventIndexNameResolver(EventToIndexNameResolver eventToIndexNameResolver) {
        if (Objects.nonNull(this.eventToIndexNameResolver)) {
            throw new IllegalStateException("eventToIndexNameResolver already set");
        }
        this.eventToIndexNameResolver = eventToIndexNameResolver;
        return this;
    }

    public EventProcessorBuilder setPipelineNameResolverCacheConfig(Duration maxHitTtl, Duration maxMissTtl) {
        return this.setPipelineNameResolverCacheSupplier(() -> new SimpleResolverCache("pipeline-name", new SimpleResolverCache.Configuration(maxHitTtl, maxMissTtl)));
    }

    public synchronized EventProcessorBuilder setPipelineNameResolverCacheSupplier(Supplier<ResolverCache<String, String>> cacheSupplier) {
        this.pipelineNameResolverCacheSupplier = cacheSupplier;
        return this;
    }

    public synchronized EventProcessorBuilder setIndexNamePipelineNameResolver(IndexNameToPipelineNameResolver indexNameToPipelineNameResolver) {
        if (Objects.nonNull(this.indexNameToPipelineNameResolver)) {
            throw new IllegalStateException("indexNameToPipelineNameResolver already set");
        }
        this.indexNameToPipelineNameResolver = indexNameToPipelineNameResolver;
        return this;
    }

    public EventProcessorBuilder setFilterMatchListener(Consumer<Event> filterMatchListener) {
        return this.setFilterMatchListener(filterMatchListener::accept);
    }

    private synchronized EventProcessorBuilder setFilterMatchListener(FilterMatchListener filterMatchListener) {
        if (Objects.nonNull(this.filterMatchListener)) {
            throw new IllegalStateException("filterMatchListener already set");
        }
        this.filterMatchListener = filterMatchListener;
        return this;
    }

    public EventProcessorBuilder addProcessor(String type, Supplier<ProcessorFactoryBridge> processorFactorySupplier) {
        return this.addProcessorsFromPlugin(SingleProcessorIngestPlugin.of(type, processorFactorySupplier));
    }

    public EventProcessorBuilder addProcessorsFromPlugin(Supplier<IngestPluginBridge> pluginSupplier, Set<String> requiredProcessors) {
        return this.addProcessorsFromPlugin(SafeSubsetIngestPlugin.safeSubset(pluginSupplier, requiredProcessors));
    }

    public synchronized EventProcessorBuilder addProcessorsFromPlugin(Supplier<IngestPluginBridge> pluginSupplier) {
        this.ingestPlugins.add(pluginSupplier);
        return this;
    }

    public synchronized EventProcessor build(PluginContext pluginContext) {
        Objects.requireNonNull(this.pipelineConfigurationResolver, "pipeline configuration resolver is REQUIRED");
        Objects.requireNonNull(this.eventToIndexNameResolver, "event index name resolver is REQUIRED");
        Objects.requireNonNull(this.indexNameToPipelineNameResolver, "pipeline name resolver is REQUIRED");
        SettingsBridge settings = SettingsBridge.builder().put("path.home", "/").put("node.name", "logstash.filter.elastic_integration." + pluginContext.pluginId()).put("ingest.grok.watchdog.interval", "1s").put("ingest.grok.watchdog.max_execution_time", "1s").build();
        ArrayList<Closeable> resourcesToClose = new ArrayList<Closeable>();
        try {
            IndexNameToPipelineNameResolver indexNameToPipelineNameResolver;
            ArrayList<CacheReloadService> services = new ArrayList<CacheReloadService>();
            ThreadPoolBridge threadPool = ThreadPoolBridge.create(settings);
            resourcesToClose.add(() -> threadPool.terminate(10L, TimeUnit.SECONDS));
            ScriptServiceBridge scriptService = ScriptServiceBridge.create(settings, threadPool::absoluteTimeInMillis);
            resourcesToClose.add(scriptService);
            EnvironmentBridge env = EnvironmentBridge.create(settings, null);
            ProcessorParametersBridge processorParameters = ProcessorParametersBridge.create(env, scriptService, threadPool);
            IngestPipelineFactory ingestPipelineFactory = new IngestPipelineFactory(scriptService);
            for (Supplier<IngestPluginBridge> ingestPluginSupplier : this.ingestPlugins) {
                IngestPluginBridge ingestPlugin = ingestPluginSupplier.get();
                if (ingestPlugin instanceof Closeable) {
                    Closeable closeableIngestPlugin = (Closeable)((Object)ingestPlugin);
                    resourcesToClose.add(closeableIngestPlugin);
                }
                Map<String, ProcessorFactoryBridge> processorFactories = ingestPlugin.getProcessors(processorParameters);
                ingestPipelineFactory = ingestPipelineFactory.withProcessors(processorFactories);
            }
            ResolverCache ingestPipelineCache = Optional.ofNullable(this.ingestPipelineResolverCacheSupplier).orElse(EventProcessorBuilder.defaultCacheSupplier("ingest-pipeline")).get();
            CachingResolver cachingInternalPipelineResolver = new SimpleIngestPipelineResolver(this.pipelineConfigurationResolver, ingestPipelineFactory).withCache(ingestPipelineCache);
            services.add(CacheReloadService.newManaged(pluginContext, ((SimpleCachingResolver)cachingInternalPipelineResolver).getReloader(), AbstractScheduledService.Scheduler.newFixedRateSchedule((Duration)CACHE_RELOAD_FREQUENCY, (Duration)CACHE_RELOAD_FREQUENCY)));
            FilterMatchListener filterMatchListener = Objects.requireNonNullElse(this.filterMatchListener, event -> {});
            IndexNameToPipelineNameResolver indexNameToPipelineNameResolver2 = this.indexNameToPipelineNameResolver;
            if (indexNameToPipelineNameResolver2 instanceof IndexNameToPipelineNameResolver.Cacheable) {
                IndexNameToPipelineNameResolver.Cacheable cacheable = (IndexNameToPipelineNameResolver.Cacheable)indexNameToPipelineNameResolver2;
                ResolverCache pipelineNameCache = Optional.ofNullable(this.pipelineNameResolverCacheSupplier).orElse(EventProcessorBuilder.defaultCacheSupplier("pipeline-name")).get();
                CachingResolver cachingPipelineNameResolver = cacheable.withCache(pipelineNameCache);
                services.add(CacheReloadService.newManaged(pluginContext, cachingPipelineNameResolver.getReloader(), AbstractScheduledService.Scheduler.newFixedRateSchedule((Duration)CACHE_RELOAD_FREQUENCY, (Duration)CACHE_RELOAD_FREQUENCY)));
                indexNameToPipelineNameResolver = cachingPipelineNameResolver::resolve;
            } else {
                indexNameToPipelineNameResolver = this.indexNameToPipelineNameResolver;
            }
            ServiceManager serviceManager = new ServiceManager(services);
            serviceManager.startAsync();
            resourcesToClose.add(() -> {
                serviceManager.stopAsync();
                serviceManager.awaitStopped();
            });
            return new EventProcessor(filterMatchListener, (IngestPipelineResolver)((Object)cachingInternalPipelineResolver), this.eventToPipelineNameResolver, this.eventToIndexNameResolver, indexNameToPipelineNameResolver, resourcesToClose);
        }
        catch (Exception e) {
            IOUtilsBridge.closeWhileHandlingException(resourcesToClose);
            throw Exceptions.wrap(e, "Failed to build EventProcessor");
        }
    }

    static {
        LogConfigurator.configureESLogging();
        CACHE_MAXIMUM_AGE = Duration.ofHours(24L);
        CACHE_RELOAD_FREQUENCY = Duration.ofSeconds(60L);
    }
}

