"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorNameAndDescriptionLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _update_connector_name_and_description_api_logic = require("../../api/connector/update_connector_name_and_description_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorNameAndDescriptionLogic = exports.ConnectorNameAndDescriptionLogic = (0, _kea.kea)({
  actions: {
    saveNameAndDescription: nameAndDescription => nameAndDescription,
    setConnector: connector => connector
  },
  connect: {
    actions: [_update_connector_name_and_description_api_logic.ConnectorNameAndDescriptionApiLogic, ['makeRequest', 'apiSuccess', 'apiError']],
    values: [_update_connector_name_and_description_api_logic.ConnectorNameAndDescriptionApiLogic, ['status']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    saveNameAndDescription: ({
      name,
      description
    }) => {
      if (values.connector) {
        actions.makeRequest({
          connectorId: values.connector.id,
          description,
          name
        });
      }
    }
  }),
  path: ['enterprise_search', 'content', 'connector', 'name_and_description'],
  reducers: () => ({
    connector: [null, {
      setConnector: (_, connector) => connector
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    isFailed: [() => [selectors.status], status => status === _api.Status.ERROR],
    isLoading: [() => [selectors.status], status => status === _api.Status.LOADING],
    isSuccess: [() => [selectors.status], status => status === _api.Status.SUCCESS]
  })
});