"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _query_client = require("../query_client");
var _config_editor_content = require("./config_editor_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/embeddable_alerts_table/public/components/config_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfigEditor = ({
  coreServices,
  initialConfig,
  onSave,
  closeFlyout,
  ariaLabelledBy
}) => {
  const {
    overlays,
    http,
    notifications
  } = coreServices;
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_config_editor_content.ConfigEditorContent, {
    ariaLabelledBy: ariaLabelledBy,
    initialConfig: initialConfig,
    onSave: newConfig => {
      onSave(newConfig);
      closeFlyout();
    },
    onCancel: closeFlyout,
    services: {
      http,
      notifications,
      overlays
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }));
};
exports.ConfigEditor = ConfigEditor;