"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchEmbeddableGridComponent = SearchEmbeddableGridComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _discoverUtils = require("@kbn/discover-utils");
var _esqlTypes = require("@kbn/esql-types");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_discover_services = require("../../hooks/use_discover_services");
var _get_allowed_sample_size = require("../../utils/get_allowed_sample_size");
var _constants = require("../constants");
var _initialize_fetch = require("../initialize_fetch");
var _saved_search_grid = require("./saved_search_grid");
var _get_search_embeddable_defaults = require("../get_search_embeddable_defaults");
var _on_resize_grid_column = require("../../utils/on_resize_grid_column");
var _context_awareness = require("../../context_awareness");
var _update_search_source = require("../utils/update_search_source");
var _data_sources = require("../../../common/data_sources");
var _replace_columns_with_variable_driven = require("../utils/replace_columns_with_variable_driven");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/embeddable/components/search_embeddable_grid_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DiscoverGridEmbeddableMemoized = /*#__PURE__*/_react.default.memo(_saved_search_grid.DiscoverGridEmbeddable);
function SearchEmbeddableGridComponent({
  api,
  dataView,
  onAddFilter,
  enableDocumentViewer,
  stateManager
}) {
  var _savedSearch$rowsPerP;
  const discoverServices = (0, _use_discover_services.useDiscoverServices)();
  const esqlVariables$ = (0, _esqlTypes.apiPublishesESQLVariables)(api.parentApi) ? api.parentApi.esqlVariables$ : undefined;
  const [emptyEsqlVariables$] = (0, _react.useState)(() => new _rxjs.BehaviorSubject(undefined));
  const [loading, savedSearch, savedSearchId, interceptedWarnings, apiQuery, apiFilters, fetchContext, rows, totalHitCount, columnsMeta, grid, panelTitle, panelDescription, savedSearchTitle, savedSearchDescription, esqlVariables] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.dataLoading$, api.savedSearch$, api.savedObjectId$, api.fetchWarnings$, api.query$, api.filters$, api.fetchContext$, stateManager.rows, stateManager.totalHitCount, stateManager.columnsMeta, stateManager.grid, api.title$, api.description$, api.defaultTitle$, api.defaultDescription$, esqlVariables$ !== null && esqlVariables$ !== void 0 ? esqlVariables$ : emptyEsqlVariables$);

  // `api.query$` and `api.filters$` are the initial values from the saved search SO (as of now)
  // `fetchContext.query` and `fetchContext.filters` are Dashboard's query and filters
  const savedSearchQuery = apiQuery;
  const savedSearchFilters = apiFilters;
  const isEsql = (0, _react.useMemo)(() => (0, _initialize_fetch.isEsqlMode)(savedSearch), [savedSearch]);
  const sort = (0, _react.useMemo)(() => {
    var _savedSearch$sort;
    return (0, _discoverUtils.getSortArray)((_savedSearch$sort = savedSearch.sort) !== null && _savedSearch$sort !== void 0 ? _savedSearch$sort : [], dataView, isEsql);
  }, [dataView, isEsql, savedSearch.sort]);
  const originalColumns = (0, _react.useMemo)(() => {
    return (0, _replace_columns_with_variable_driven.replaceColumnsWithVariableDriven)(savedSearch.columns, columnsMeta, esqlVariables, isEsql);
  }, [columnsMeta, isEsql, esqlVariables, savedSearch.columns]);
  const {
    columns,
    onAddColumn,
    onRemoveColumn,
    onMoveColumn,
    onSetColumns
  } = (0, _unifiedDataTable.useColumns)({
    capabilities: discoverServices.capabilities,
    defaultOrder: discoverServices.uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews: discoverServices.dataViews,
    setAppState: params => {
      if (params.columns) {
        stateManager.columns.next(params.columns);
      }
      if (params.sort) {
        stateManager.sort.next(params.sort);
      }
      if (params.settings) {
        stateManager.grid.next(params.settings);
      }
    },
    columns: originalColumns,
    sort,
    settings: grid
  });
  const dataSource = (0, _react.useMemo)(() => (0, _data_sources.createDataSource)({
    dataView,
    query: savedSearchQuery
  }), [dataView, savedSearchQuery]);
  const timeRange = (0, _react.useMemo)(() => fetchContext ? (0, _update_search_source.getTimeRangeFromFetchContext)(fetchContext) : undefined, [fetchContext]);
  const cellActionsMetadata = (0, _context_awareness.useAdditionalCellActions)({
    dataSource,
    dataView,
    query: savedSearchQuery,
    filters: savedSearchFilters,
    timeRange
  });

  // Security Solution overrides our cell actions -- this is a temporary workaroud to keep
  // things working as they do currently until we can migrate their actions to One Discover
  const isInSecuritySolution = (0, _useObservable.default)(discoverServices.application.currentAppId$) === 'securitySolutionUI';
  const onStateEditedProps = (0, _react.useMemo)(() => ({
    onAddColumn,
    onSetColumns,
    onMoveColumn,
    onRemoveColumn,
    onUpdateRowsPerPage: newRowsPerPage => {
      stateManager.rowsPerPage.next(newRowsPerPage);
    },
    onUpdateRowHeight: newRowHeight => {
      stateManager.rowHeight.next(newRowHeight);
    },
    onUpdateHeaderRowHeight: newHeaderRowHeight => {
      stateManager.headerRowHeight.next(newHeaderRowHeight);
    },
    onSort: nextSort => {
      const sortOrderArr = [];
      nextSort.forEach(arr => {
        sortOrderArr.push(arr);
      });
      stateManager.sort.next(sortOrderArr);
    },
    onUpdateSampleSize: newSampleSize => {
      stateManager.sampleSize.next(newSampleSize);
    },
    onUpdateDataGridDensity: newDensity => {
      stateManager.density.next(newDensity);
    },
    onResize: newGridSettings => {
      stateManager.grid.next((0, _on_resize_grid_column.onResizeGridColumn)(newGridSettings, grid));
    }
  }), [onAddColumn, onSetColumns, onMoveColumn, onRemoveColumn, stateManager.rowsPerPage, stateManager.rowHeight, stateManager.headerRowHeight, stateManager.sort, stateManager.sampleSize, stateManager.density, stateManager.grid, grid]);
  const fetchedSampleSize = (0, _react.useMemo)(() => {
    return (0, _get_allowed_sample_size.getAllowedSampleSize)(savedSearch.sampleSize, discoverServices.uiSettings);
  }, [savedSearch.sampleSize, discoverServices]);
  const defaults = (0, _get_search_embeddable_defaults.getSearchEmbeddableDefaults)(discoverServices.uiSettings);
  return /*#__PURE__*/_react.default.createElement(DiscoverGridEmbeddableMemoized, (0, _extends2.default)({}, onStateEditedProps, {
    columns: columns,
    dataView: dataView,
    interceptedWarnings: interceptedWarnings,
    onFilter: onAddFilter,
    rows: rows,
    rowsPerPageState: (_savedSearch$rowsPerP = savedSearch.rowsPerPage) !== null && _savedSearch$rowsPerP !== void 0 ? _savedSearch$rowsPerP : defaults.rowsPerPage,
    sampleSizeState: fetchedSampleSize,
    searchDescription: panelDescription || savedSearchDescription,
    sort: sort,
    totalHitCount: totalHitCount,
    settings: savedSearch.grid,
    ariaLabelledBy: 'documentsAriaLabel',
    cellActionsTriggerId: isInSecuritySolution ? _constants.SEARCH_EMBEDDABLE_CELL_ACTIONS_TRIGGER_ID : _context_awareness.DISCOVER_CELL_ACTIONS_TRIGGER.id,
    cellActionsMetadata: isInSecuritySolution ? undefined : cellActionsMetadata,
    cellActionsHandling: isInSecuritySolution ? 'replace' : 'append',
    columnsMeta: columnsMeta,
    configHeaderRowHeight: defaults.headerRowHeight,
    configRowHeight: defaults.rowHeight,
    headerRowHeightState: savedSearch.headerRowHeight,
    rowHeightState: savedSearch.rowHeight,
    isPlainRecord: isEsql,
    loadingState: Boolean(loading) ? _unifiedDataTable.DataLoadingState.loading : _unifiedDataTable.DataLoadingState.loaded,
    maxAllowedSampleSize: (0, _get_allowed_sample_size.getMaxAllowedSampleSize)(discoverServices.uiSettings),
    query: savedSearchQuery,
    filters: savedSearchFilters,
    savedSearchId: savedSearchId,
    searchTitle: panelTitle || savedSearchTitle,
    services: discoverServices,
    showTimeCol: !discoverServices.uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false),
    dataGridDensityState: savedSearch.density,
    enableDocumentViewer: enableDocumentViewer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 5
    }
  }));
}