"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityTracesDataSourceProfileProviders = void 0;
var _profile = require("./profile");
var _sub_profiles = require("./sub_profiles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createObservabilityTracesDataSourceProfileProviders = providerServices => {
  const tracesDataSourceProfileProvider = (0, _profile.createTracesDataSourceProfileProvider)(providerServices);
  return [(0, _sub_profiles.createTracesAPMDataSourceProfileProvider)(tracesDataSourceProfileProvider), (0, _sub_profiles.createTracesOtelDataSourceProfileProvider)(tracesDataSourceProfileProvider), tracesDataSourceProfileProvider];
};
exports.createObservabilityTracesDataSourceProfileProviders = createObservabilityTracesDataSourceProfileProviders;