"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityGenericDocumentProfileProvider = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../../../../../common/constants");
var _profiles = require("../../../../profiles");
var _accessors = require("./accessors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OBSERVABILITY_GENERIC_DOCUMENT_PROFILE_ID = 'observability-generic-document-profile';
const createObservabilityGenericDocumentProfileProvider = ({
  tracesContextService,
  apmErrorsContextService,
  logsContextService
}) => ({
  profileId: OBSERVABILITY_GENERIC_DOCUMENT_PROFILE_ID,
  restrictedToProductFeature: _constants.TRACES_PRODUCT_FEATURE_ID,
  profile: {
    getDocViewer: (0, _accessors.createGetDocViewer)({
      apm: {
        errors: apmErrorsContextService.getErrorsIndexPattern(),
        traces: tracesContextService.getAllTracesIndexPattern()
      },
      logs: logsContextService.getAllLogsIndexPattern()
    })
  },
  resolve: ({
    record,
    rootContext
  }) => {
    const isObservabilitySolutionView = rootContext.solutionType === _profiles.SolutionType.Observability;
    if (isObservabilitySolutionView && isGenericDocument(record)) {
      return {
        isMatch: true,
        context: {
          type: _profiles.DocumentType.Generic
        }
      };
    }
    return {
      isMatch: false
    };
  }
});
exports.createObservabilityGenericDocumentProfileProvider = createObservabilityGenericDocumentProfileProvider;
function isGenericDocument(record) {
  const traceId = (0, _discoverUtils.getFieldValue)(record, _discoverUtils.TRACE_ID_FIELD);
  return !!traceId;
}