"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EstimatedData = EstimatedData;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _constants = require("../../../../common/constants");
var _translations = require("../../../../common/translations");
var _data_placeholder = require("./data_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/summary_panel/estimated_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EstimatedData() {
  const {
    estimatedData,
    isEstimatedDataLoading,
    isUserAuthorizedForDataset
  } = (0, _hooks.useSummaryPanelContext)();
  return /*#__PURE__*/_react.default.createElement(_data_placeholder.DataPlaceholder, {
    title: _translations.summaryPanelEstimatedDataText,
    tooltip: _translations.summaryPanelEstimatedDataTooltipText,
    value: (0, _eui.formatNumber)(estimatedData, _constants.BYTE_NUMBER_FORMAT),
    isLoading: isEstimatedDataLoading,
    isUserAuthorizedForDataset: isUserAuthorizedForDataset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
}