"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapMatchAll = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mapMatchAll = filter => {
  if ((0, _esQuery.isMatchAllFilter)(filter)) {
    return {
      type: _esQuery.FILTERS.MATCH_ALL,
      key: filter.meta.field,
      value: filter.meta.formattedValue || 'all'
    };
  }
  throw filter;
};
exports.mapMatchAll = mapMatchAll;