"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndicesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _track_ui_metric = require("../../../services/track_ui_metric");
var _constants = require("../../../constants");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/sections/home/follower_indices_list/follower_indices_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REFRESH_RATE_MS = 30000;
const getQueryParamName = ({
  location: {
    search
  }
}) => {
  const {
    name
  } = (0, _shared_imports.extractQueryParams)(search);
  return name ? decodeURIComponent(name) : null;
};
class FollowerIndicesList extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      lastFollowerIndexId: null,
      isDetailPanelOpen: false
    });
  }
  static getDerivedStateFromProps({
    followerIndexId
  }, {
    lastFollowerIndexId
  }) {
    if (followerIndexId !== lastFollowerIndexId) {
      return {
        lastFollowerIndexId: followerIndexId,
        isDetailPanelOpen: !!followerIndexId
      };
    }
    return null;
  }
  componentDidMount() {
    const {
      loadFollowerIndices,
      selectFollowerIndex,
      history
    } = this.props;
    (0, _track_ui_metric.trackUiMetric)(_track_ui_metric.METRIC_TYPE.LOADED, _constants.UIM_FOLLOWER_INDEX_LIST_LOAD);
    loadFollowerIndices();

    // Select the pattern in the URL query params
    selectFollowerIndex(getQueryParamName(history));

    // Interval to load follower indices in the background passing "true" to the fetch method
    this.interval = setInterval(() => loadFollowerIndices(true), REFRESH_RATE_MS);
  }
  componentDidUpdate(prevProps, prevState) {
    const {
      history
    } = this.props;
    const {
      lastFollowerIndexId
    } = this.state;

    /**
     * Each time our state is updated (through getDerivedStateFromProps())
     * we persist the follower index id to query params for deep linking
     */
    if (lastFollowerIndexId !== prevState.lastFollowerIndexId) {
      if (!lastFollowerIndexId) {
        history.replace({
          search: ''
        });
      } else {
        history.replace({
          search: `?name=${encodeURIComponent(lastFollowerIndexId)}`
        });
      }
    }
  }
  componentWillUnmount() {
    clearInterval(this.interval);
  }
  renderEmpty() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "managementApp",
      "data-test-subj": "emptyPrompt",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexList.emptyPromptTitle",
        defaultMessage: "Create your first follower index",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexList.emptyPromptDescription",
        defaultMessage: "Use a follower index to replicate a leader index on a remote cluster.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 13
        }
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, `/follower_indices/add`), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "createFollowerIndexButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.addFollowerButtonLabel",
        defaultMessage: "Create a follower index",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    });
  }
  renderLoading() {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexList.loadingTitle",
      defaultMessage: "Loading follower indices...",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }));
  }
  renderList() {
    const {
      selectFollowerIndex,
      followerIndices
    } = this.props;
    const {
      isDetailPanelOpen
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexList.followerIndicesDescription",
      defaultMessage: "A follower index replicates a leader index on a remote cluster.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.FollowerIndicesTable, {
      followerIndices: followerIndices,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }), isDetailPanelOpen && /*#__PURE__*/_react.default.createElement(_components.DetailPanel, {
      closeDetailPanel: () => selectFollowerIndex(null),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 31
      }
    }));
  }
  render() {
    const {
      followerIndices,
      apiError,
      isAuthorized,
      apiStatus
    } = this.props;
    const isEmpty = apiStatus === _constants.API_STATUS.IDLE && !followerIndices.length;
    if (!isAuthorized) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexList.permissionErrorTitle",
          defaultMessage: "Permission error",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 171,
            columnNumber: 13
          }
        }),
        error: {
          error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexList.noPermissionText",
            defaultMessage: "You do not have permission to view or add follower indices.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 178,
              columnNumber: 15
            }
          })
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 9
        }
      });
    }
    if (apiError) {
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexList.loadingErrorTitle', {
        defaultMessage: 'Error loading follower indices'
      });
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: title,
        error: apiError.body,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 14
        }
      });
    }
    if (isEmpty) {
      return this.renderEmpty();
    }
    if (apiStatus === _constants.API_STATUS.LOADING) {
      return this.renderLoading();
    }
    return this.renderList();
  }
}
exports.FollowerIndicesList = FollowerIndicesList;
(0, _defineProperty2.default)(FollowerIndicesList, "propTypes", {
  loadFollowerIndices: _propTypes.default.func,
  selectFollowerIndex: _propTypes.default.func,
  followerIndices: _propTypes.default.array,
  apiStatus: _propTypes.default.string,
  apiError: _propTypes.default.object
});