"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPrepend = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _play_button = require("./play_button");
var _time_slider_strings = require("./time_slider_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/timeslider_control/components/time_slider_prepend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeSliderPrepend = props => {
  const [isPaused, setIsPaused] = (0, _react.useState)(true);
  const [timeoutId, setTimeoutId] = (0, _react.useState)(undefined);
  const [subscription, setSubscription] = (0, _react.useState)(undefined);
  const playNextFrame = (0, _react.useCallback)(() => {
    // advance to next frame
    props.onNext();
    if (props.waitForControlOutputConsumersToLoad$) {
      const nextFrameSubscription = props.waitForControlOutputConsumersToLoad$.pipe((0, _rxjs.first)()).subscribe(() => {
        // use timeout to display frame for small time period before moving to next frame
        const nextTimeoutId = window.setTimeout(() => {
          playNextFrame();
        }, 1750);
        setTimeoutId(nextTimeoutId);
      });
      setSubscription(nextFrameSubscription);
    }
  }, [props]);
  const onPlay = (0, _react.useCallback)(() => {
    props.setIsPopoverOpen(true);
    setIsPaused(false);
    playNextFrame();
  }, [props, playNextFrame]);
  const onPause = (0, _react.useCallback)(() => {
    props.setIsPopoverOpen(true);
    setIsPaused(true);
    if (subscription) {
      subscription.unsubscribe();
      setSubscription(undefined);
    }
    if (timeoutId) {
      clearTimeout(timeoutId);
      setTimeoutId(undefined);
    }
  }, [props, subscription, timeoutId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      onPause();
      props.onPrevious();
    },
    iconType: "framePrevious",
    color: "text",
    "aria-label": _time_slider_strings.TimeSliderStrings.control.getPreviousButtonAriaLabel(),
    "data-test-subj": "timeSlider-previousTimeWindow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_play_button.PlayButton, {
    onPlay: onPlay,
    onPause: onPause,
    waitForControlOutputConsumersToLoad$: props.waitForControlOutputConsumersToLoad$,
    viewMode: props.viewMode,
    disablePlayButton: props.disablePlayButton,
    isPaused: isPaused,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      onPause();
      props.onNext();
    },
    iconType: "frameNext",
    color: "text",
    "aria-label": _time_slider_strings.TimeSliderStrings.control.getNextButtonAriaLabel(),
    "data-test-subj": "timeSlider-nextTimeWindow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  })));
};
exports.TimeSliderPrepend = TimeSliderPrepend;