"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOptionsListESQLControlState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * ----------------------------------------------------------------
 * Options list state types
 * ----------------------------------------------------------------
 */

const isOptionsListESQLControlState = state => typeof state !== 'undefined' && Object.hasOwn(state, 'esqlQuery') && Object.hasOwn(state, 'controlType') && !Object.hasOwn(state, 'fieldName');

/**
 * ----------------------------------------------------------------
 * Options list server request + response types
 * ----------------------------------------------------------------
 */

/**
 * The Options list response is returned from the serverside Options List route.
 */

/**
 * The invalid selections are parsed **after** the server returns with the result from the ES client; so, the
 * suggestion aggregation parser only returns the suggestions list + the cardinality of the result
 */

/**
 * The Options list request type taken in by the public Options List service.
 */

/**
 * The Options list request body is sent to the serverside Options List route and is used to create the ES query.
 */
exports.isOptionsListESQLControlState = isOptionsListESQLControlState;