"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSeverityUserActionBuilder = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../create/translations");
var _common = require("./common");
var _config = require("../severity/config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/severity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getLabelTitle = userAction => {
  const severity = userAction.payload.severity;
  const severityData = _config.severities[severity];
  if (severityData === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": `${userAction.id}-user-action-severity-title`,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, _translations.SET_SEVERITY_TO), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `${userAction.id}-user-action-severity-title-${severity}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_config.SeverityHealth, {
    severity: severity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  })));
};
const createSeverityUserActionBuilder = ({
  userAction,
  userProfiles,
  handleOutlineComment
}) => ({
  build: () => {
    const severityUserAction = userAction;
    const label = getLabelTitle(severityUserAction);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userProfiles,
      userAction,
      handleOutlineComment,
      label,
      icon: 'dot'
    });
    return commonBuilder.build();
  }
});
exports.createSeverityUserActionBuilder = createSeverityUserActionBuilder;