"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewAlerts = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _types = require("../../../../common/types");
var _kibana = require("../../../common/lib/kibana");
var _use_get_feature_ids = require("../../../containers/use_get_feature_ids");
var _case_view_tabs = require("../case_view_tabs");
var _case_view_alerts_empty = require("./case_view_alerts_empty");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/case_view_alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CaseViewAlerts = ({
  caseData,
  renderAlertsTable: CustomAlertsTable,
  onAlertsTableLoaded
}) => {
  var _alertData$ruleTypeId;
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings
  } = services;
  const alertIds = (0, _helpers.getManualAlertIds)(caseData.comments);
  const alertIdsQuery = (0, _react.useMemo)(() => ({
    ids: {
      values: alertIds
    }
  }), [alertIds]);
  const {
    isLoading: isLoadingAlertFeatureIds,
    data: alertData
  } = (0, _use_get_feature_ids.useGetFeatureIds)(alertIds, caseData.owner !== _constants.SECURITY_SOLUTION_OWNER);
  const onLoaded = (0, _react.useCallback)(({
    alerts
  }) => onAlertsTableLoaded === null || onAlertsTableLoaded === void 0 ? void 0 : onAlertsTableLoaded(alerts), [onAlertsTableLoaded]);
  if (alertIdsQuery.ids.values.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
      caseData: caseData,
      activeTab: _types.CASE_VIEW_PAGE_TABS.ALERTS,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_case_view_alerts_empty.CaseViewAlertsEmpty, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    })));
  }
  const AlertsTable = CustomAlertsTable !== null && CustomAlertsTable !== void 0 ? CustomAlertsTable : _responseOpsAlertsTable.AlertsTable;
  return isLoadingAlertFeatureIds ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-view-alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.ALERTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AlertsTable, (0, _extends2.default)({
    id: `case-details-alerts-${caseData.owner}`,
    ruleTypeIds: caseData.owner === _constants.SECURITY_SOLUTION_OWNER ? _securitysolutionRules.SECURITY_SOLUTION_RULE_TYPE_IDS : (_alertData$ruleTypeId = alertData === null || alertData === void 0 ? void 0 : alertData.ruleTypeIds) !== null && _alertData$ruleTypeId !== void 0 ? _alertData$ruleTypeId : [],
    consumers: alertData === null || alertData === void 0 ? void 0 : alertData.featureIds,
    query: alertIdsQuery,
    showAlertStatusWithFlapping: caseData.owner !== _constants.SECURITY_SOLUTION_OWNER,
    onLoaded: onLoaded
    // Only provide the services to the default alerts table.
    // Spreading from object to avoid incorrectly overriding
    // services to `undefined` in custom solution tables
  }, CustomAlertsTable ? {} : {
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      settings,
      // In the Cases UI the licensing service is defined
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      licensing: licensing
    }
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  })));
};
exports.CaseViewAlerts = CaseViewAlerts;
CaseViewAlerts.displayName = 'CaseViewAlerts';