"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServicesWithoutTransactions = getServicesWithoutTransactions;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _elasticAgentUtils = require("@kbn/elastic-agent-utils");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _document_type = require("../../../../common/document_type");
var _service_group_query_with_overflow = require("../../../lib/service_group_query_with_overflow");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServicesWithoutTransactions({
  environment,
  apmEventClient,
  maxNumServices,
  kuery,
  start,
  end,
  serviceGroup,
  randomSampler,
  documentType,
  rollupInterval,
  searchQuery
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  const isServiceTransactionMetric = documentType === _document_type.ApmDocumentType.ServiceTransactionMetric;
  const response = await apmEventClient.search(isServiceTransactionMetric ? 'get_services_from_service_summary' : 'get_services_from_error_and_metric_documents', {
    apm: isServiceTransactionMetric ? {
      sources: [{
        documentType: _document_type.ApmDocumentType.ServiceSummaryMetric,
        rollupInterval
      }]
    } : {
      events: [_common.ProcessorEvent.metric, _common.ProcessorEvent.error]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...(0, _service_group_query_with_overflow.serviceGroupWithOverflowQuery)(serviceGroup), ...(0, _server.wildcardQuery)(_apm.SERVICE_NAME, searchQuery)]
      }
    },
    aggs: {
      sample: {
        random_sampler: randomSampler,
        aggs: {
          services: {
            terms: {
              field: _apm.SERVICE_NAME,
              size: maxNumServices
            },
            aggs: {
              environments: {
                terms: {
                  field: _apm.SERVICE_ENVIRONMENT
                }
              },
              telemetryAgentName: {
                terms: {
                  field: _apm.TELEMETRY_SDK_LANGUAGE
                }
              },
              telemetrySdkName: {
                terms: {
                  field: _apm.TELEMETRY_SDK_NAME
                }
              },
              latest: {
                top_metrics: {
                  metrics: [{
                    field: _apm.AGENT_NAME
                  }],
                  sort: {
                    '@timestamp': 'desc'
                  }
                }
              }
            }
          }
        }
      }
    }
  });
  const maxCountExceeded = ((_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.sample.services.sum_other_doc_count) !== null && _response$aggregation !== void 0 ? _response$aggregation : 0) > 0;
  return {
    services: (_response$aggregation3 = (_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.sample.services.buckets.map(bucket => {
      var _bucket$telemetryAgen, _bucket$telemetrySdkN;
      return {
        serviceName: bucket.key,
        environments: bucket.environments.buckets.map(envBucket => envBucket.key),
        agentName: (0, _elasticAgentUtils.getAgentName)(bucket.latest.top[0].metrics[_apm.AGENT_NAME], (_bucket$telemetryAgen = bucket.telemetryAgentName.buckets[0]) === null || _bucket$telemetryAgen === void 0 ? void 0 : _bucket$telemetryAgen.key, (_bucket$telemetrySdkN = bucket.telemetrySdkName.buckets[0]) === null || _bucket$telemetrySdkN === void 0 ? void 0 : _bucket$telemetrySdkN.key)
      };
    })) !== null && _response$aggregation3 !== void 0 ? _response$aggregation3 : [],
    maxCountExceeded
  };
}