"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyValueFilterList = KeyValueFilterList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/key_value_filter_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiAccordion = (0, _styled.default)(_eui.EuiAccordion)`
  width: 100%;
  .buttonContentContainer .euiIEFlexWrapFix {
    width: 100%;
  }
`;
const StyledEuiDescriptionList = (0, _styled.default)(_eui.EuiDescriptionList)`
  margin: ${({
  theme
}) => `${theme.euiTheme.size.s} ${theme.euiTheme.size.s} 0 ${theme.euiTheme.size.s}`};
  .descriptionList__title,
  .descriptionList__description {
    margin-top: 0;
    align-items: center;
    display: flex;
`;
function removeEmptyValues(items) {
  return items.filter(({
    value
  }) => !(0, _lodash.isEmpty)(value));
}
function KeyValueFilterList({
  icon,
  title,
  keyValueList,
  initialIsOpen = false,
  onClickFilter
}) {
  const nonEmptyKeyValueList = removeEmptyValues(keyValueList);
  if (!nonEmptyKeyValueList.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    initialIsOpen: initialIsOpen,
    id: title,
    buttonContent: /*#__PURE__*/_react.default.createElement(AccordionButtonContent, {
      icon: icon,
      title: title,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 22
      }
    }),
    buttonClassName: "buttonContentContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiDescriptionList, {
    type: "column",
    columnWidths: ['20%', '80%'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, nonEmptyKeyValueList.map(({
    key,
    value,
    isFilterable
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "descriptionList__title",
      css: (0, _react2.css)`
                  height: 40px;
                `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: (0, _react2.css)`
                    font-weight: bold;
                  `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    }, key)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "descriptionList__description",
      css: (0, _react2.css)`
                  height: 40px;
                `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      responsive: false,
      gutterSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: (0, _react2.css)`
                      min-width: 32px;
                    `,
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 19
      }
    }, isFilterable && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.apm.keyValueFilterList.actionFilterLabel', {
        defaultMessage: 'Filter by value'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "filter",
      color: "text",
      size: "m",
      onClick: () => {
        onClickFilter({
          key,
          value
        });
      },
      "aria-label": _i18n.i18n.translate('xpack.apm.keyValueFilterList.actionFilterLabel', {
        defaultMessage: 'Filter by value'
      }),
      "data-test-subj": `filter_by_${key}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 25
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 21
      }
    }, value)))));
  })));
}
function AccordionButtonContent({
  icon,
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 5
    }
  }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "l",
    title: title,
    "data-test-subj": "accordion_title_icon",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, title)));
}