"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAIL_SAMPLING_ENABLED_KEY = void 0;
exports.getTailSamplingSettings = getTailSamplingSettings;
exports.isTailBasedSamplingValid = isTailBasedSamplingValid;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _utils = require("../settings_form/utils");
var _duration_rt = require("../../../../../common/agent_configuration/runtime_types/duration_rt");
var _storage_size_rt = require("../../../../../common/agent_configuration/runtime_types/storage_size_rt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/fleet_integration/apm_policy_form/settings_definition/tail_sampling_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TAIL_SAMPLING_ENABLED_KEY = exports.TAIL_SAMPLING_ENABLED_KEY = 'tail_sampling_enabled';
function getTailSamplingSettings(docsLinks) {
  return [{
    key: TAIL_SAMPLING_ENABLED_KEY,
    rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingEnabledTitle', {
      defaultMessage: 'Enable tail-based sampling'
    }),
    rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.enableTailSamplingDescription', {
      defaultMessage: 'Enable tail-based sampling.'
    }),
    type: 'boolean',
    settings: [{
      key: 'tail_sampling_interval',
      type: 'duration',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingInterval', {
        defaultMessage: 'Tail sampling interval'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingIntervalTitle', {
        defaultMessage: 'Interval'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingIntervalDescription', {
        defaultMessage: 'Interval for synchronization between multiple APM Servers. Should be in the order of tens of seconds or low minutes.'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      required: false,
      validation: (0, _duration_rt.getDurationRt)({
        min: '1s'
      })
    }, {
      key: 'tail_sampling_policies',
      type: 'yaml',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingPolicies', {
        defaultMessage: 'Tail sampling policies'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingPoliciesTitle', {
        defaultMessage: 'Policies'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingPoliciesDescription', {
        defaultMessage: 'Policies map trace events to a sample rate. Each policy must specify a sample rate. Trace events are matched to policies in the order specified. All policy conditions must be true for a trace event to match. Each policy list should conclude with a policy that only specifies a sample rate. This final policy is used to catch remaining trace events that don’t match a stricter policy.'
      }),
      helpText: docsLinks && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.fleet_integration.settings.tailSamplingDocsHelpText",
        defaultMessage: "Learn more about tail sampling policies in our {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "apmGetTailSamplingSettingsDocsLink",
            href: docsLinks,
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 80,
              columnNumber: 19
            }
          }, _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSamplingDocsHelpTextLink', {
            defaultMessage: 'docs'
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 13
        }
      }),
      required: true
    }, {
      key: 'tail_sampling_storage_limit',
      type: 'storageSize',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingStorageLimit', {
        defaultMessage: 'Tail sampling storage limit'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingStorageLimitTitle', {
        defaultMessage: 'Storage limit'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingStorageLimitDescription', {
        defaultMessage: 'The amount of storage space allocated for trace events matching tail sampling policies. Caution: Setting this limit higher than the allowed space may cause APM Server to become unhealthy.'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      required: false,
      validation: (0, _storage_size_rt.getStorageSizeRt)({
        min: '0GB'
      })
    }, {
      key: 'tail_sampling_ttl',
      type: 'duration',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingTTL', {
        defaultMessage: 'Tail sampling TTL (Time-to-live)'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingTTLTitle', {
        defaultMessage: 'TTL (Time-to-live)'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingTTLDescription', {
        defaultMessage: 'Time-to-live (TTL) for trace events stored in the local storage of the APM Server during tail-based sampling. This TTL determines how long trace events are retained in the local storage while waiting for a sampling decision to be made. A greater TTL value increases storage space requirements. Should be at least 2 * Interval.'
      }),
      labelAppend: _utils.OPTIONAL_LABEL,
      required: false,
      validation: (0, _duration_rt.getDurationRt)({
        min: '1s'
      })
    }, {
      key: 'tail_sampling_discard_on_write_failure',
      type: 'boolean',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingDiscardOnWriteFailure', {
        defaultMessage: 'Tail sampling discard on write failure'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingDiscardOnWriteFailureTitle', {
        defaultMessage: 'Discard on write failure'
      }),
      rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tailSampling.tailSamplingDiscardOnWriteFailureDescription', {
        defaultMessage: 'Defines the indexing behavior when trace events fail to be written to storage (for example, when the storage limit is reached). When set to `false`, traces bypass sampling and are always indexed, which significantly increases the indexing load. When set to `true`, traces are discarded, causing data loss which can result in broken traces.'
      }),
      required: false
    }]
  }];
}
function isTailBasedSamplingValid(newVars, tailSamplingSettings) {
  // only validates TBS when its flag is enabled
  return !newVars[TAIL_SAMPLING_ENABLED_KEY].value || (0, _utils.isSettingsFormValid)(tailSamplingSettings, newVars);
}