"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeAttachment = RuntimeAttachment;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _discovery_rule = require("./discovery_rule");
var _default_discovery_rule = require("./default_discovery_rule");
var _edit_discovery_rule = require("./edit_discovery_rule");
var _java_agent_version_input = require("./java_agent_version_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/fleet_integration/apm_agents/runtime_attachment/runtime_attachment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_AGENT_VERSION = 'latest';
function RuntimeAttachment({
  isEnabled,
  onToggleEnable,
  discoveryRuleList,
  setDiscoveryRuleList,
  onDelete,
  editDiscoveryRuleId,
  onEdit,
  onChangeOperation,
  stagedOperationText,
  onChangeType,
  stagedTypeText,
  onChangeProbe,
  stagedProbeText,
  onCancel,
  onSubmit,
  onAddRule,
  operationTypes,
  toggleDescription,
  discoveryRulesDescription,
  showUnsavedWarning,
  onDragEnd,
  version,
  onChangeVersion,
  isValidVersion
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, showUnsavedWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.unsavedRules', {
      defaultMessage: 'You have unsaved changes. Click "Save integration" to sync changes to the integration.'
    }),
    color: "warning",
    iconType: "info",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.enableRuntimeAttachement', {
      defaultMessage: 'Enable runtime attachment'
    }),
    checked: isEnabled,
    onChange: onToggleEnable,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, toggleDescription))), isEnabled && /*#__PURE__*/_react.default.createElement(_java_agent_version_input.JavaAgentVersionInput, {
    version: version || DEFAULT_AGENT_VERSION,
    onChange: onChangeVersion,
    isValid: isValidVersion,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  })), isEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.discoveryRules', {
    defaultMessage: 'Discovery rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 17
    }
  }, discoveryRulesDescription))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmRuntimeAttachmentAddRuleButton",
    iconType: "plusInCircle",
    disabled: editDiscoveryRuleId !== null,
    onClick: onAddRule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.addRule', {
    defaultMessage: 'Add rule'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "RUNTIME_ATTACHMENT_DROPPABLE",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, discoveryRuleList.map(({
    discoveryRule,
    id
  }, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    key: id,
    index: idx,
    draggableId: id,
    customDragHandle: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, provided => id === editDiscoveryRuleId ? /*#__PURE__*/_react.default.createElement(_edit_discovery_rule.EditDiscoveryRule, {
    id: editDiscoveryRuleId,
    onChangeOperation: onChangeOperation,
    operation: stagedOperationText,
    onChangeType: onChangeType,
    type: stagedTypeText,
    onChangeProbe: onChangeProbe,
    probe: stagedProbeText,
    onCancel: onCancel,
    onSubmit: onSubmit,
    operationTypes: operationTypes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 23
    }
  }) : /*#__PURE__*/_react.default.createElement(_discovery_rule.DiscoveryRule, {
    id: id,
    order: idx + 1,
    operation: discoveryRule.operation,
    type: discoveryRule.type,
    probe: discoveryRule.probe,
    providedDragHandleProps: provided.dragHandleProps,
    onDelete: onDelete,
    onEdit: onEdit,
    operationTypes: operationTypes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react.default.createElement(_default_discovery_rule.DefaultDiscoveryRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }));
}