"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMenuSections = getMenuSections;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _common = require("@kbn/logs-shared-plugin/common");
var _common2 = require("@kbn/metrics-data-access-plugin/common");
var _sections_helper = require("../../../../shared/transaction_action_menu/sections_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInfraMetricsQuery(timestamp) {
  if (!timestamp) {
    return undefined;
  }
  const timeInMilliseconds = new Date(timestamp).getTime();
  const fiveMinutes = _moment.default.duration(5, 'minutes').asMilliseconds();
  return {
    from: new Date(timeInMilliseconds - fiveMinutes).toISOString(),
    to: new Date(timeInMilliseconds + fiveMinutes).toISOString()
  };
}
function getMenuSections({
  instanceDetails,
  basePath,
  onFilterByInstanceClick,
  metricsHref,
  logsLocator,
  assetDetailsLocator
}) {
  var _instanceDetails$kube, _instanceDetails$kube2, _instanceDetails$cont;
  const podId = (_instanceDetails$kube = instanceDetails.kubernetes) === null || _instanceDetails$kube === void 0 ? void 0 : (_instanceDetails$kube2 = _instanceDetails$kube.pod) === null || _instanceDetails$kube2 === void 0 ? void 0 : _instanceDetails$kube2.uid;
  const containerId = (_instanceDetails$cont = instanceDetails.container) === null || _instanceDetails$cont === void 0 ? void 0 : _instanceDetails$cont.id;
  const time = instanceDetails['@timestamp'] ? new Date(instanceDetails['@timestamp']).valueOf() : undefined;
  const infraMetricsQuery = getInfraMetricsQuery(instanceDetails['@timestamp']);
  const podLogsHref = logsLocator.getRedirectUrl({
    query: (0, _common.getNodeQuery)({
      nodeField: (0, _common2.findInventoryFields)('pod').id,
      nodeId: podId
    }),
    timeRange: (0, _common.getTimeRange)(time)
  });
  const containerLogsHref = logsLocator.getRedirectUrl({
    query: (0, _common.getNodeQuery)({
      nodeField: (0, _common2.findInventoryFields)('container').id,
      nodeId: containerId
    }),
    timeRange: (0, _common.getTimeRange)(time)
  });
  const hasPodLink = !!podId && !!assetDetailsLocator;
  const hasContainerLink = !!containerId && !!assetDetailsLocator;
  const podActions = [{
    key: 'podLogs',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.podLogs', {
      defaultMessage: 'Pod logs'
    }),
    href: podLogsHref,
    condition: !!podId
  }, {
    key: 'podMetrics',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.podMetrics', {
      defaultMessage: 'Pod metrics'
    }),
    href: hasPodLink ? assetDetailsLocator.getRedirectUrl({
      entityId: podId,
      entityType: 'pod',
      assetDetails: {
        dateRange: infraMetricsQuery
      }
    }) : undefined,
    condition: hasPodLink
  }];
  const containerActions = [{
    key: 'containerLogs',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.containerLogs', {
      defaultMessage: 'Container logs'
    }),
    href: containerLogsHref,
    condition: !!containerId
  }, {
    key: 'containerMetrics',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.containerMetrics', {
      defaultMessage: 'Container metrics'
    }),
    href: hasContainerLink ? assetDetailsLocator.getRedirectUrl({
      entityId: containerId,
      entityType: 'container',
      assetDetails: {
        dateRange: infraMetricsQuery
      }
    }) : undefined,
    condition: hasContainerLink
  }];
  const apmActions = [{
    key: 'filterByInstance',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.filterByInstance', {
      defaultMessage: 'Filter overview by instance'
    }),
    onClick: onFilterByInstanceClick,
    condition: true
  }, {
    key: 'analyzeRuntimeMetric',
    label: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.metrics', {
      defaultMessage: 'Metrics'
    }),
    href: metricsHref,
    condition: true
  }];
  const sectionRecord = {
    observability: [{
      key: 'podDetails',
      title: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.pod.title', {
        defaultMessage: 'Pod details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.pod.subtitle', {
        defaultMessage: 'View logs and metrics for this pod to get further details.'
      }),
      actions: podActions
    }, {
      key: 'containerDetails',
      title: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.container.title', {
        defaultMessage: 'Container details'
      }),
      subtitle: _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.actionMenus.container.subtitle', {
        defaultMessage: 'View logs and metrics for this container to get further details.'
      }),
      actions: containerActions
    }],
    apm: [{
      key: 'apm',
      actions: apmActions
    }]
  };
  return (0, _sections_helper.getNonEmptySections)(sectionRecord);
}