"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.agentStatusCheckInstruction = agentStatusCheckInstruction;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/agent_status_instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AgentStatusWarningCallout() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "agentStatusWarningCallout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.onboarding.agentStatus.warning.calloutMessage', {
    defaultMessage: 'No data has been received from agents yet'
  }));
}
function AgentStatusSuccessCallout() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "success",
    "data-test-subj": "agentStatusSuccessCallout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.apm.onboarding.agentStatus.success.calloutMessage', {
    defaultMessage: 'Data successfully received from one or more agents'
  }));
}
function agentStatusCheckInstruction({
  checkAgentStatus,
  agentStatus,
  agentStatusLoading
}) {
  let status = 'incomplete';
  let statusCallout = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  // Explicit false check required as this value can be null initially. API returns true/false based on data present
  if (agentStatus === false) {
    status = 'warning';
    statusCallout = /*#__PURE__*/_react.default.createElement(AgentStatusWarningCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 21
      }
    });
  }
  if (agentStatus) {
    status = 'complete';
    statusCallout = /*#__PURE__*/_react.default.createElement(AgentStatusSuccessCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 21
      }
    });
  }
  return {
    title: _i18n.i18n.translate('xpack.apm.onboarding.agentStatusCheck.title', {
      defaultMessage: 'Explore your data'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.agentStatusCheck.textPre', {
      defaultMessage: 'Make sure your application is running and data is flowing into Elastic Observability.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "checkAgentStatus",
      onClick: checkAgentStatus,
      isLoading: agentStatusLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.agentStatus.check', {
      defaultMessage: 'Check status'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }), statusCallout),
    status
  };
}