"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapAsyncSearchClient = wrapAsyncSearchClient;
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function wrapAsyncSearchClient({
  strategy,
  client,
  abortController,
  logger,
  rule
}) {
  let numSearches = 0;
  let esSearchDurationMs = 0;
  let totalSearchDurationMs = 0;
  return {
    getMetrics: () => {
      return {
        numSearches,
        esSearchDurationMs,
        totalSearchDurationMs
      };
    },
    async search({
      request,
      options
    }) {
      const start = Date.now();
      logger.debug(() => `executing async search for rule ${rule.alertTypeId}:${rule.id} in space ${rule.spaceId} - ${JSON.stringify(request)} - with options ${JSON.stringify(options)}`);
      return (0, _rxjs.lastValueFrom)(client.search(request, {
        ...options,
        strategy,
        abortSignal: abortController.signal
      }).pipe((0, _rxjs.catchError)(error => {
        if (abortController.signal.aborted) {
          return (0, _rxjs.throwError)(() => new Error('Search has been aborted due to cancelled execution'));
        }
        return (0, _rxjs.throwError)(() => error);
      }), (0, _rxjs.filter)(response => !(0, _common.isRunningResponse)(response)), (0, _rxjs.tap)(response => {
        var _response$rawResponse;
        const durationMs = Date.now() - start;
        numSearches++;
        esSearchDurationMs += (_response$rawResponse = response.rawResponse.took) !== null && _response$rawResponse !== void 0 ? _response$rawResponse : 0;
        totalSearchDurationMs += durationMs;
      }), (0, _rxjs.map)(response => {
        return response.rawResponse;
      })));
    }
  };
}