"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snoozeResponseSchema = exports.snoozeParamsSchema = exports.snoozeBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _schedule = require("../../../../../schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const snoozeParamsSchema = exports.snoozeParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'Identifier of the rule.'
    }
  })
});
const snoozeBodySchema = exports.snoozeBodySchema = _configSchema.schema.object({
  schedule: _configSchema.schema.object({
    custom: _configSchema.schema.maybe(_schedule.scheduleRequestSchemaV1)
  })
});
const snoozeResponseSchema = exports.snoozeResponseSchema = _configSchema.schema.object({
  body: _configSchema.schema.object({
    schedule: _configSchema.schema.object({
      id: _configSchema.schema.string({
        meta: {
          description: 'Identifier of the snooze schedule.'
        }
      }),
      custom: _configSchema.schema.maybe(_schedule.scheduleRequestSchemaV1)
    })
  })
});