"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postReadinessTaskRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _constants2 = require("../../../../common/api/siem_readiness/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_READINESS_INDEX = 'security_solution-siem_readiness';
const postReadinessTaskRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: _constants2.POST_SIEM_READINESS_TASK_API_PATH,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: _configSchema.schema.object({
          task_id: _configSchema.schema.string(),
          status: _configSchema.schema.oneOf([_configSchema.schema.literal('completed'), _configSchema.schema.literal('incomplete')]),
          meta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
            unknowns: 'allow'
          }))
        })
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const core = await context.core;
      const esClient = core.elasticsearch.client.asCurrentUser;
      const indexDocument = {
        ...request.body,
        '@timestamp': new Date().toISOString()
      };
      await esClient.index({
        index: SIEM_READINESS_INDEX,
        body: indexDocument,
        refresh: 'true' // Force refresh to make the document searchable immediately
      });
      logger.info(`Indexed SIEM readiness task (${request.body.task_id}) to ${SIEM_READINESS_INDEX}`);
      return response.ok({
        body: request.body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error logging SIEM readiness task (${request.body.task_id}): ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.postReadinessTaskRoute = postReadinessTaskRoute;