"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMonitoringEntitySourceRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../../common/constants");
var _entity_analytics = require("../../../../../../common/api/entity_analytics");
var _assert_advanced_setting_enabled = require("../../../utils/assert_advanced_setting_enabled");
var _status_service = require("../../engine/status_service");
var _saved_object = require("../../auth/saved_object");
var _monitoring_entity_source_type = require("../../saved_objects/monitoring_entity_source_type");
var _constants2 = require("../../constants");
/* eslint-disable @kbn/eslint/require-license-header */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMonitoringEntitySourceRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: _constants.MONITORING_ENTITY_SOURCE_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: _entity_analytics.CreateEntitySourceRequestBody
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
      const secSol = await context.securitySolution;
      const client = secSol.getMonitoringEntitySourceDataClient();
      const body = await client.init(request.body);
      const privMonDataClient = await secSol.getPrivilegeMonitoringDataClient();
      const soClient = privMonDataClient.getScopedSoClient(request, {
        includedHiddenTypes: [_saved_object.PrivilegeMonitoringApiKeyType.name, _monitoring_entity_source_type.monitoringEntitySourceType.name]
      });
      const statusService = (0, _status_service.createEngineStatusService)(privMonDataClient, soClient);
      const engineStatus = await statusService.get();
      try {
        if (engineStatus.status === _constants2.PRIVILEGE_MONITORING_ENGINE_STATUS.STARTED) {
          await statusService.scheduleNow();
        }
      } catch (e) {
        logger.warn(`[Privilege Monitoring] Error scheduling task, received ${e.message}`);
      }
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error creating monitoring entity source sync config: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.createMonitoringEntitySourceRoute = createMonitoringEntitySourceRoute;