"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initPrivilegeMonitoringEngineRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _assert_advanced_setting_enabled = require("../../utils/assert_advanced_setting_enabled");
var _initialisation_service = require("../engine/initialisation_service");
var _saved_object = require("../auth/saved_object");
var _saved_objects = require("../saved_objects");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initPrivilegeMonitoringEngineRoute = (router, logger, config) => {
  router.versioned.post({
    access: 'public',
    path: _constants.MONITORING_ENGINE_INIT_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
    const dataClient = secSol.getPrivilegeMonitoringDataClient();
    const soClient = dataClient.getScopedSoClient(request, {
      includedHiddenTypes: [_saved_object.PrivilegeMonitoringApiKeyType.name, _saved_objects.monitoringEntitySourceType.name]
    });
    const service = (0, _initialisation_service.createInitialisationService)(dataClient, soClient);
    try {
      const initResult = await service.init();
      if (initResult.status === _constants2.PRIVILEGE_MONITORING_ENGINE_STATUS.ERROR) {
        return siemResponse.error({
          statusCode: 500,
          body: initResult
        });
      }
      return response.ok({
        body: initResult
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error initializing privilege monitoring engine: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.initPrivilegeMonitoringEngineRoute = initPrivilegeMonitoringEngineRoute;