"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGapDetectedTelemetryEvent = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _events = require("../../../../telemetry/event_based/events");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendGapDetectedTelemetryEvent = ({
  analytics,
  interval,
  gapDuration,
  originalFrom,
  originalTo,
  ruleParams
}) => {
  const intervalDuration = (0, _utils.parseInterval)(interval);
  if (!intervalDuration) {
    return;
  }
  const ruleType = ruleParams.type;
  const ruleSource = ruleParams.ruleSource;
  const isCustomized = (ruleSource === null || ruleSource === void 0 ? void 0 : ruleSource.type) === 'external' ? ruleSource.isCustomized : false;
  analytics.reportEvent(_events.GAP_DETECTED_EVENT.eventType, {
    gapDuration: gapDuration.asMilliseconds(),
    intervalDuration: intervalDuration.asMilliseconds(),
    intervalAndLookbackDuration: _moment.default.duration(originalTo.diff(originalFrom)).asMilliseconds(),
    ruleType,
    ruleSource: ruleSource === null || ruleSource === void 0 ? void 0 : ruleSource.type,
    isCustomized
  });
};
exports.sendGapDetectedTelemetryEvent = sendGapDetectedTelemetryEvent;