"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEqlSearchRequest = void 0;
var _fp = require("lodash/fp");
var _build_events_query = require("../utils/build_events_query");
var _get_query_filter = require("../utils/get_query_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildEqlSearchRequest = ({
  sharedParams,
  query,
  from,
  to,
  size,
  filters,
  eventCategoryOverride,
  timestampField,
  tiebreakerField
}) => {
  const {
    inputIndex: index,
    primaryTimestamp,
    secondaryTimestamp,
    exceptionFilter,
    runtimeMappings
  } = sharedParams;
  const timestamps = secondaryTimestamp ? [primaryTimestamp, secondaryTimestamp] : [primaryTimestamp];
  const docFields = timestamps.map(tstamp => ({
    field: tstamp,
    format: 'strict_date_optional_time'
  }));
  const esFilter = (0, _get_query_filter.getQueryFilter)({
    query: '',
    language: 'eql',
    filters: filters || [],
    index,
    exceptionFilter
  });
  const rangeFilter = (0, _build_events_query.buildTimeRangeFilter)({
    to,
    from,
    primaryTimestamp,
    secondaryTimestamp
  });
  const requestFilter = [rangeFilter, esFilter];
  const fields = [{
    field: '*',
    include_unmapped: true
  }, ...docFields];
  return {
    index,
    allow_no_indices: true,
    size,
    query,
    filter: {
      bool: {
        filter: requestFilter
      }
    },
    // the allow_partial_search_results query parameter will supersede
    // the corresponding xpack settings on cluster
    // issue: https://github.com/elastic/kibana/issues/208760
    allow_partial_search_results: true,
    runtime_mappings: runtimeMappings,
    timestamp_field: timestampField,
    event_category_field: eventCategoryOverride,
    ...(!(0, _fp.isEmpty)(tiebreakerField) ? {
      tiebreaker_field: tiebreakerField
    } : {}),
    fields
  };
};
exports.buildEqlSearchRequest = buildEqlSearchRequest;