"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggsQuery = exports.ENTITY_INDEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_INDEX = exports.ENTITY_INDEX = '.entities*';
const getAggsQuery = (termsField, size = 10, index = ENTITY_INDEX) => ({
  size: 0,
  index,
  aggs: {
    field_terms: {
      terms: {
        field: termsField,
        size,
        order: {
          last_doc_timestamp: 'desc'
        }
      },
      aggs: {
        last_doc_timestamp: {
          max: {
            field: '@timestamp'
          }
        }
      }
    }
  }
});
exports.getAggsQuery = getAggsQuery;