"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldAsString = getFieldAsString;
exports.getSupportedSchemas = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _security_modules = require("./security_modules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This structure defines the preset supported schemas for a resolver graph. We'll probably want convert this
 * implementation to something similar to how row renderers is implemented.
 */

const getSupportedSchemas = experimentalFeatures => {
  const microsoftDefenderEndpointDataInAnalyzerEnabled = experimentalFeatures === null || experimentalFeatures === void 0 ? void 0 : experimentalFeatures.microsoftDefenderEndpointDataInAnalyzerEnabled;

  // Build the list of active security modules based on feature flags
  const activeSecurityModules = [..._security_modules.CORE_SECURITY_MODULES, ...(microsoftDefenderEndpointDataInAnalyzerEnabled ? _security_modules.MICROSOFT_DEFENDER_MODULES : [])];

  // Get all supported filebeat datasets for the active modules
  const supportedFileBeatDataSets = (0, _security_modules.getSecurityModuleDatasets)(activeSecurityModules);
  return [{
    name: 'endpoint',
    constraints: [{
      field: 'agent.type',
      value: 'endpoint'
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      ancestry: 'process.Ext.ancestry',
      name: 'process.name',
      agentId: 'agent.id'
    }
  }, {
    name: 'winlogbeat',
    constraints: [{
      field: 'agent.type',
      value: 'winlogbeat'
    }, {
      field: 'event.module',
      value: 'sysmon'
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      name: 'process.name'
    }
  }, {
    name: 'sysmonViaFilebeat',
    constraints: [{
      field: 'agent.type',
      value: 'filebeat'
    }, {
      field: 'event.dataset',
      value: 'windows.sysmon_operational'
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      name: 'process.name'
    }
  }, {
    name: 'filebeat',
    constraints: [{
      field: 'agent.type',
      value: 'filebeat'
    }, {
      field: 'event.dataset',
      value: supportedFileBeatDataSets
    }],
    schema: {
      id: 'process.entity_id',
      parent: 'process.parent.entity_id',
      name: 'process.name'
    }
  }];
};
exports.getSupportedSchemas = getSupportedSchemas;
function getFieldAsString(doc, field) {
  const value = _lodash.default.get(doc, field);
  if (value === undefined) {
    return undefined;
  }
  return String(value);
}