"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.UnifiedTimeline = exports.SAMPLE_SIZE_SETTING = exports.HIDE_FOR_SIZES = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/data-plugin/public");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _popularize_field = require("@kbn/unified-data-table/src/utils/popularize_field");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react2 = require("@emotion/react");
var _unifiedFieldList = require("@kbn/unified-field-list");
var _event_details_width_context = require("../../../../common/components/events_viewer/event_details_width_context");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../body/column_headers/helpers");
var _styles = require("./styles");
var _translations = require("./data_table/translations");
var _resizable_layout = require("./resizable_layout");
var _data_table = _interopRequireDefault(require("./data_table"));
var _store = require("../../../store");
var _get_fields_list_creation_options = require("./get_fields_list_creation_options");
var _default_headers = require("../body/column_headers/default_headers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/unified_components/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimelineBodyContainer = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `${className}`
}))`
  width: 100%;
  height: 100%;
`;
const DataGridMemoized = /*#__PURE__*/_react.default.memo(_data_table.default);
const DROP_PROPS = {
  value: {
    id: 'dscDropZoneTable',
    humanData: {
      label: _translations.DRAG_DROP_FIELD
    }
  },
  order: [1, 0, 0, 0],
  types: ['field_add']
};
const SidebarPanelFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;

  .unifiedFieldListSidebar {
    padding-bottom: ${props => props.theme.eui.euiSizeS};
    padding-left: 0px;
    border-top: 1px solid ${props => props.theme.eui.euiColorLightShade};

    .unifiedFieldListSidebar__group {
      .euiFlexItem:last-child {
        /* padding-right: ${props => props.theme.eui.euiSizeS}; */
      }

      .unifiedFieldListSidebar__list {
        padding-left: 0px;
      }

      .unifiedFieldListSidebar__addBtn {
        margin-right: ${props => props.theme.eui.euiSizeS};
      }
    }
  }
`;
const SAMPLE_SIZE_SETTING = exports.SAMPLE_SIZE_SETTING = 500;
const HIDE_FOR_SIZES = exports.HIDE_FOR_SIZES = ['xs', 's'];
const UnifiedTimelineComponent = ({
  columns,
  isSortEnabled,
  activeTab,
  timelineId,
  itemsPerPage,
  itemsPerPageOptions,
  rowRenderers,
  sort,
  events,
  refetch,
  dataLoadingState,
  totalCount,
  onFetchMoreRecords,
  updatedAt,
  isTextBasedQuery,
  dataView,
  trailingControlColumns,
  leadingControlColumns,
  onUpdatePageIndex
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const unifiedFieldListContainerRef = (0, _react.useRef)(null);
  const {
    services: {
      uiSettings,
      fieldFormats,
      dataViews,
      dataViewFieldEditor,
      application: {
        capabilities
      },
      uiActions,
      charts,
      docLinks,
      analytics,
      timelineDataService
    }
  } = (0, _kibana.useKibana)();
  const {
    query: {
      filterManager: timelineFilterManager
    }
  } = timelineDataService;
  const fieldListSidebarServices = (0, _react.useMemo)(() => ({
    fieldFormats,
    dataViews,
    dataViewFieldEditor,
    data: timelineDataService,
    uiActions,
    charts,
    core: {
      analytics,
      uiSettings,
      docLinks
    }
  }), [fieldFormats, dataViews, dataViewFieldEditor, timelineDataService, uiActions, charts, uiSettings, docLinks, analytics]);
  const [, setMainContainer] = (0, _react.useState)(null);
  const columnIds = (0, _react.useMemo)(() => {
    return columns.map(c => c.id);
  }, [columns]);
  const sortingColumns = (0, _react.useMemo)(() => {
    return (sort === null || sort === void 0 ? void 0 : sort.map(sortingCol => [sortingCol.columnId, sortingCol.sortDirection])) || [];
  }, [sort]);
  const onSort = (0, _react.useCallback)(nextSort => {
    dispatch(_store.timelineActions.updateSort({
      id: timelineId,
      sort: nextSort.map(([id, direction]) => {
        const currentColumn = columns.find(column => column.id === id);
        const columnType = currentColumn ? currentColumn.type : 'keyword';
        return {
          columnId: id,
          columnType,
          sortDirection: direction,
          // esTypes is needed so that the sort object remains consistent with the
          // default sort value and does not creates an unnecessary search request
          esTypes: id === '@timestamp' ? ['date'] : []
        };
      })
    }));
  }, [dispatch, timelineId, columns]);
  const setAppState = (0, _react.useCallback)(newState => {
    if (newState.sort) {
      onSort(newState.sort);
    } else {
      const columnsStates = newState.columns.map(columnId => (0, _helpers.getColumnHeader)(columnId, _default_headers.defaultUdtHeaders));
      dispatch(_store.timelineActions.updateColumns({
        id: timelineId,
        columns: columnsStates
      }));
    }
  }, [dispatch, onSort, timelineId]);
  const {
    columns: currentColumnIds,
    onAddColumn,
    onRemoveColumn,
    onSetColumns
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    dataView: dataView,
    dataViews,
    setAppState,
    columns: columnIds,
    sort: sortingColumns
  });
  const onSetColumnsTimeline = (0, _react.useCallback)(nextColumns => {
    const shouldUnifiedTableKeepColumnsUnchanged = true;
    // to support the legacy table, unified table has the ability to automatically
    // prepend timestamp field column to the table. We do not want that, otherwise
    // the list of columns returned does not have timestamp field because unifiedDataTable assumes that
    // it is automatically available in the table.
    onSetColumns(nextColumns, shouldUnifiedTableKeepColumnsUnchanged);
  }, [onSetColumns]);
  const onAddFilter = (0, _react.useCallback)((field, values, operation) => {
    if (dataView && timelineFilterManager) {
      const fieldName = typeof field === 'string' ? field : field.name;
      (0, _popularize_field.popularizeField)(dataView, fieldName, dataViews, capabilities);
      const newFilters = (0, _public.generateFilters)(timelineFilterManager, field, values, operation, dataView);
      return timelineFilterManager.addFilters(newFilters);
    }
  }, [timelineFilterManager, dataView, dataViews, capabilities]);
  const [{
    dragging
  }] = (0, _domDragDrop.useDragDropContext)();
  const draggingFieldName = dragging === null || dragging === void 0 ? void 0 : dragging.id;
  const onToggleColumn = (0, _react.useCallback)(columnId => {
    dispatch(_store.timelineActions.upsertColumn({
      column: (0, _helpers.getColumnHeader)(columnId, _default_headers.defaultUdtHeaders),
      id: timelineId,
      index: 1
    }));
  }, [dispatch, timelineId]);
  const isDropAllowed = (0, _react.useMemo)(() => {
    if (!draggingFieldName || columnIds.includes(draggingFieldName)) {
      return false;
    }
    return true;
  }, [draggingFieldName, columnIds]);
  const onDropFieldToTable = (0, _react.useCallback)(() => {
    if (draggingFieldName) {
      onAddColumn(draggingFieldName);
      onToggleColumn(draggingFieldName);
    }
  }, [draggingFieldName, onAddColumn, onToggleColumn]);
  const onAddFieldToWorkspace = (0, _react.useCallback)(field => {
    onAddColumn(field.name);
    onToggleColumn(field.name);
  }, [onAddColumn, onToggleColumn]);
  const onRemoveFieldFromWorkspace = (0, _react.useCallback)(field => {
    if (columns.some(({
      id
    }) => id === field.name)) {
      dispatch(_store.timelineActions.removeColumn({
        columnId: field.name,
        id: timelineId
      }));
    }
    onRemoveColumn(field.name);
  }, [columns, dispatch, onRemoveColumn, timelineId]);
  const onFieldEdited = (0, _react.useCallback)(() => {
    refetch();
  }, [refetch]);
  const wrappedOnFieldEdited = (0, _react.useCallback)(async () => {
    onFieldEdited();
  }, [onFieldEdited]);
  return /*#__PURE__*/_react.default.createElement(TimelineBodyContainer, {
    className: "timelineBodyContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_resizable_layout.TimelineResizableLayout, {
    unifiedFieldListSidebarContainerApi: unifiedFieldListContainerRef.current,
    sidebarPanel: /*#__PURE__*/_react.default.createElement(SidebarPanelFlexGroup, {
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 351,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "sidebarContainer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 13
      }
    }, dataView && /*#__PURE__*/_react.default.createElement(_unifiedFieldList.UnifiedFieldListSidebarContainer, {
      ref: unifiedFieldListContainerRef,
      showFieldList: true,
      variant: "responsive",
      getCreationOptions: _get_fields_list_creation_options.getFieldsListCreationOptions,
      services: fieldListSidebarServices,
      dataView: dataView,
      fullWidth: true,
      allFields: dataView.fields,
      workspaceSelectedFieldNames: columnIds,
      onAddFieldToWorkspace: onAddFieldToWorkspace,
      onRemoveFieldFromWorkspace: onRemoveFieldFromWorkspace,
      onAddFilter: onAddFilter,
      onFieldEdited: wrappedOnFieldEdited,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
      sizes: HIDE_FOR_SIZES,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: (0, _react2.css)`
                  border-right: ${euiTheme.border.thin};
                `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 15
      }
    }))),
    mainPanel: /*#__PURE__*/_react.default.createElement(_styles.StyledPageContentWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_styles.StyledMainEuiPanel, {
      role: "main",
      panelRef: setMainContainer,
      paddingSize: "none",
      borderRadius: "none",
      hasShadow: false,
      hasBorder: false,
      color: "transparent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_domDragDrop.Droppable, {
      dropTypes: isDropAllowed ? DROP_PROPS.types : undefined,
      value: DROP_PROPS.value,
      order: DROP_PROPS.order,
      onDrop: onDropFieldToTable,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_domDragDrop.DropOverlayWrapper, {
      isVisible: isDropAllowed,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 398,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_event_details_width_context.EventDetailsWidthProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 399,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(DataGridMemoized, {
      columns: columns,
      columnIds: currentColumnIds,
      dataView: dataView,
      rowRenderers: rowRenderers,
      timelineId: timelineId,
      isSortEnabled: isSortEnabled,
      itemsPerPage: itemsPerPage,
      itemsPerPageOptions: itemsPerPageOptions,
      sort: sortingColumns,
      onSort: onSort,
      onSetColumns: onSetColumnsTimeline,
      events: events,
      refetch: refetch,
      onFieldEdited: onFieldEdited,
      dataLoadingState: dataLoadingState,
      totalCount: totalCount,
      onFetchMoreRecords: onFetchMoreRecords,
      activeTab: activeTab,
      updatedAt: updatedAt,
      isTextBasedQuery: isTextBasedQuery,
      onFilter: onAddFilter,
      trailingControlColumns: trailingControlColumns,
      leadingControlColumns: leadingControlColumns,
      onUpdatePageIndex: onUpdatePageIndex,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 400,
        columnNumber: 21
      }
    })))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 7
    }
  }));
};
const UnifiedTimeline = exports.default = exports.UnifiedTimeline = /*#__PURE__*/_react.default.memo(UnifiedTimelineComponent);
// eslint-disable-next-line import/no-default-export