"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFullScreen = exports.default = exports.ToolbarAdditionalControlsComponent = exports.ToolbarAdditionalControls = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("../../../../../helpers");
var _timeline = require("../../../../../../common/types/timeline");
var _use_full_screen = require("../../../../../common/containers/use_full_screen");
var _row_renderers_browser = require("../../../row_renderers_browser");
var i18n = _interopRequireWildcard(require("./translations"));
var _exit_full_screen = require("../../../../../common/components/exit_full_screen");
var _last_updated = require("../../footer/last_updated");
var _row_renderer_switch = require("../../../row_renderer_switch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/unified_components/data_table/toolbar_additional_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isFullScreen = ({
  globalFullScreen,
  isActiveTimelines,
  timelineFullScreen
}) => isActiveTimelines && timelineFullScreen || isActiveTimelines === false && globalFullScreen;
exports.isFullScreen = isFullScreen;
const ToolbarAdditionalControlsComponent = ({
  timelineId,
  updatedAt
}) => {
  const {
    timelineFullScreen,
    setTimelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const {
    globalFullScreen,
    setGlobalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const toolTipRef = (0, _react.useRef)(null);
  const hideToolTip = () => {
    var _toolTipRef$current;
    return (_toolTipRef$current = toolTipRef.current) === null || _toolTipRef$current === void 0 ? void 0 : _toolTipRef$current.hideToolTip();
  };
  const toggleFullScreen = (0, _react.useCallback)(() => {
    hideToolTip();
    if (timelineId === _timeline.TimelineId.active) {
      setTimelineFullScreen(!timelineFullScreen);
    } else {
      setGlobalFullScreen(!globalFullScreen);
    }
  }, [timelineId, setTimelineFullScreen, timelineFullScreen, setGlobalFullScreen, globalFullScreen]);
  const fullScreen = (0, _react.useMemo)(() => isFullScreen({
    globalFullScreen,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(timelineId),
    timelineFullScreen
  }), [globalFullScreen, timelineFullScreen, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_row_renderer_switch.RowRendererSwitch, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_row_renderers_browser.StatefulRowRenderersBrowser, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_last_updated.LastUpdatedContainer, {
    updatedAt: updatedAt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "rightPosition",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    ref: toolTipRef,
    content: fullScreen ? i18n.EXIT_FULL_SCREEN : i18n.FULL_SCREEN,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": fullScreen ? i18n.EXIT_FULL_SCREEN : i18n.FULL_SCREEN,
    className: `${fullScreen ? _exit_full_screen.EXIT_FULL_SCREEN_CLASS_NAME : ''}`,
    color: fullScreen ? 'text' : 'primary',
    "data-test-subj":
    // a full screen button gets created for timeline and for the host page
    // this sets the data-test-subj for each case so that tests can differentiate between them
    (0, _helpers.isActiveTimeline)(timelineId) ? 'full-screen-active' : 'full-screen',
    iconType: fullScreen ? 'fullScreenExit' : 'fullScreen',
    onClick: toggleFullScreen,
    onMouseOut: hideToolTip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))));
};
exports.ToolbarAdditionalControlsComponent = ToolbarAdditionalControlsComponent;
const ToolbarAdditionalControls = exports.default = exports.ToolbarAdditionalControls = /*#__PURE__*/_react.default.memo(ToolbarAdditionalControlsComponent);
// eslint-disable-next-line import/no-default-export