"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchOrFilter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _timeline = require("../../../../../common/api/timeline");
var _constants = require("../../../../common/store/inputs/constants");
var _super_date_picker = require("../../../../common/components/super_date_picker");
var _query_bar = require("../query_bar");
var _components = require("../../../../sourcerer/components");
var _data_view_picker = require("../../../../data_view_manager/components/data_view_picker");
var _date_picker_lock = require("../date_picker_lock");
var _model = require("../../../../sourcerer/store/model");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/search_or_filter/search_or_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchOrFilterContainer = _styledComponents.default.div`
  overflow-x: auto;
  overflow-y: hidden;
`;
SearchOrFilterContainer.displayName = 'SearchOrFilterContainer';
const ModeFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  user-select: none; // Again, why?
`;
ModeFlexItem.displayName = 'ModeFlexItem';
const SearchOrFilter = exports.SearchOrFilter = /*#__PURE__*/_react.default.memo(({
  dataProviders,
  isRefreshPaused,
  filters,
  filterManager,
  filterQuery,
  from,
  fromStr,
  kqlMode,
  timelineId,
  refreshInterval,
  savedQueryId,
  setSavedQueryId,
  to,
  toStr,
  updateReduxTime,
  isDataProviderVisible,
  toggleDataProviderVisibility,
  timelineType
}) => {
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const isDataProviderEmpty = (0, _react.useMemo)(() => (dataProviders === null || dataProviders === void 0 ? void 0 : dataProviders.length) === 0, [dataProviders]);
  const dataProviderIconTooltipContent = (0, _react.useMemo)(() => {
    if (isDataProviderVisible) {
      return _translations.DATA_PROVIDER_VISIBLE;
    }
    if (isDataProviderEmpty) {
      return _translations.DATA_PROVIDER_HIDDEN_EMPTY;
    }
    return _translations.DATA_PROVIDER_HIDDEN_POPULATED;
  }, [isDataProviderEmpty, isDataProviderVisible]);
  const buttonColor = (0, _react.useMemo)(() => isDataProviderEmpty || isDataProviderVisible ? 'primary' : 'warning', [isDataProviderEmpty, isDataProviderVisible]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SearchOrFilterContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "timeline-search-or-filter",
    gutterSize: "xs",
    alignItems: "flexStart",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, newDataViewPickerEnabled ? /*#__PURE__*/_react.default.createElement(_data_view_picker.DataViewPicker, {
    scope: _model.SourcererScopeName.timeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.Sourcerer, {
    scope: _model.SourcererScopeName.timeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "timeline-search-or-filter-search-container",
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_query_bar.QueryBarTimeline, {
    dataProviders: dataProviders,
    filters: filters,
    filterManager: filterManager,
    filterQuery: filterQuery,
    from: from,
    fromStr: fromStr,
    kqlMode: kqlMode,
    isRefreshPaused: isRefreshPaused,
    refreshInterval: refreshInterval,
    savedQueryId: savedQueryId,
    setSavedQueryId: setSavedQueryId,
    timelineId: timelineId,
    to: to,
    toStr: toStr,
    updateReduxTime: updateReduxTime,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  })),
  /*
  DataProvider toggle is not needed in template timeline because
  it is always visible
  */
  timelineType === _timeline.TimelineTypeEnum.default ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: dataProviderIconTooltipContent,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": dataProviderIconTooltipContent,
    color: buttonColor,
    "data-test-subj": "toggle-data-provider",
    display: "base",
    iconType: "timeline",
    isSelected: isDataProviderVisible,
    onClick: toggleDataProviderVisibility,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 21
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_date_picker_lock.TimelineDatePickerLock, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "timeline-date-picker-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_super_date_picker.SuperDatePicker, {
    compressed: true,
    disabled: false,
    id: _constants.InputsModelId.timeline,
    timelineId: timelineId,
    width: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  })))));
});
SearchOrFilter.displayName = 'SearchOrFilter';