"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProviderItemBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/api/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../../store");
var _provider_badge = require("./provider_badge");
var _provider_item_actions = require("./provider_item_actions");
var _drag_and_drop = require("../../../../common/store/drag_and_drop");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/data_providers/provider_item_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProviderItemBadge = exports.ProviderItemBadge = /*#__PURE__*/_react.default.memo(({
  andProviderId,
  browserFields,
  deleteProvider,
  field,
  kqlQuery,
  isEnabled,
  isExcluded,
  isPopoverOpen,
  onDataProviderEdited,
  operator,
  providerId,
  register,
  setIsPopoverOpen,
  timelineId,
  toggleEnabledProvider,
  toggleExcludedProvider,
  toggleTypeProvider,
  displayValue,
  val,
  type = _timeline.DataProviderTypeEnum.default,
  wrapperRef
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const timelineType = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline$timeline, _getTimeline;
    if (!timelineId) {
      return _timeline.TimelineTypeEnum.default;
    }
    return (_getTimeline$timeline = (_getTimeline = getTimeline(state, timelineId)) === null || _getTimeline === void 0 ? void 0 : _getTimeline.timelineType) !== null && _getTimeline$timeline !== void 0 ? _getTimeline$timeline : _timeline.TimelineTypeEnum.default;
  });
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen, setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    var _wrapperRef$current;
    setIsPopoverOpen(false);
    wrapperRef === null || wrapperRef === void 0 ? void 0 : (_wrapperRef$current = wrapperRef.current) === null || _wrapperRef$current === void 0 ? void 0 : _wrapperRef$current.focus();
  }, [wrapperRef, setIsPopoverOpen]);
  const onToggleEnabledProvider = (0, _react.useCallback)(() => {
    toggleEnabledProvider();
    closePopover();
  }, [closePopover, toggleEnabledProvider]);
  const onToggleExcludedProvider = (0, _react.useCallback)(() => {
    toggleExcludedProvider();
    closePopover();
  }, [toggleExcludedProvider, closePopover]);
  const onToggleTypeProvider = (0, _react.useCallback)(() => {
    toggleTypeProvider();
    closePopover();
  }, [toggleTypeProvider, closePopover]);
  const [providerRegistered, setProviderRegistered] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    // optionally register the provider if provided
    if (register != null) {
      dispatch(_drag_and_drop.dragAndDropActions.registerProvider({
        provider: {
          ...register,
          and: []
        }
      }));
      setProviderRegistered(true);
    }
  }, [providerRegistered, dispatch, register, setProviderRegistered]);
  const unRegisterProvider = (0, _react.useCallback)(() => {
    if (providerRegistered && register != null) {
      dispatch(_drag_and_drop.dragAndDropActions.unRegisterProvider({
        id: register.id
      }));
    }
  }, [providerRegistered, dispatch, register]);
  (0, _react.useEffect)(() => () => {
    unRegisterProvider();
  }, [unRegisterProvider]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_provider_badge.ProviderBadge, {
    deleteProvider: deleteProvider,
    field: field,
    kqlQuery: kqlQuery,
    isEnabled: isEnabled,
    isExcluded: isExcluded,
    providerId: providerId,
    togglePopover: togglePopover,
    toggleType: onToggleTypeProvider,
    displayValue: displayValue !== null && displayValue !== void 0 ? displayValue : String(val),
    val: val,
    operator: operator,
    type: type,
    timelineType: timelineType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }), [deleteProvider, displayValue, field, isEnabled, isExcluded, kqlQuery, onToggleTypeProvider, operator, providerId, timelineType, togglePopover, type, val]);
  return /*#__PURE__*/_react.default.createElement(_provider_item_actions.ProviderItemActions, {
    andProviderId: andProviderId,
    browserFields: browserFields,
    button: button,
    closePopover: closePopover,
    deleteProvider: deleteProvider,
    field: field,
    kqlQuery: kqlQuery,
    isEnabled: isEnabled,
    isExcluded: isExcluded,
    isOpen: isPopoverOpen,
    onDataProviderEdited: onDataProviderEdited,
    operator: operator,
    providerId: providerId,
    timelineId: timelineId,
    timelineType: timelineType,
    toggleEnabledProvider: onToggleEnabledProvider,
    toggleExcludedProvider: onToggleExcludedProvider,
    toggleTypeProvider: onToggleTypeProvider,
    value: val,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  });
});
ProviderItemBadge.displayName = 'ProviderItemBadge';