"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegistryEventDetails = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../helpers");
var _registry_event_details_line = require("./registry_event_details_line");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/registry/registry_event_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RegistryEventDetailsComponent = ({
  contextId,
  data,
  text,
  scopeId
}) => {
  const hostName = (0, _fp.get)('host.name[0]', data);
  const id = data._id;
  const processName = (0, _fp.get)('process.name[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const registryKey = (0, _fp.get)('registry.key[0]', data);
  const registryPath = (0, _fp.get)('registry.path[0]', data);
  const userDomain = (0, _fp.get)('user.domain[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  if ((0, _helpers.isNillEmptyOrNotFinite)(registryKey)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_helpers.Details, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_registry_event_details_line.RegistryEventDetailsLine, {
    scopeId: scopeId,
    contextId: contextId,
    hostName: hostName,
    id: id,
    processName: processName,
    processPid: processPid,
    registryKey: registryKey,
    registryPath: registryPath,
    text: text,
    userDomain: userDomain,
    userName: userName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
};
RegistryEventDetailsComponent.displayName = 'RegistryEventDetailsComponent';
const RegistryEventDetails = exports.RegistryEventDetails = /*#__PURE__*/_react.default.memo(RegistryEventDetailsComponent);