"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileHash = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/file_hash.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HashFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const FileHash = exports.FileHash = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fileHashSha256,
  scopeId
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(fileHashSha256)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(HashFlexGroup, {
    alignItems: "center",
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "div",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "file.hash.sha256",
    iconType: "number",
    value: fileHashSha256,
    isAggregatable: true,
    fieldType: "keyword",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })));
});
FileHash.displayName = 'FileHash';